/****************************************************************************
** DialogAudio
**
**   Created : Tue Dec 5 12:09:08 2006
**        by : Varol Okan using XEmacs
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class encapsulates the Dialog to assign audio to a language and / or
** mark the audio stream or transcoding.
**
****************************************************************************/

#ifndef DIALOGAUDIO_H
#define DIALOGAUDIO_H

#include "uidialogaudio.h"

class TranscodeInterface;
class SourceFileEntry;
class SourceFileInfo;
class AudioEntry;
class DVDMenu;
class Audio;

class DialogAudio : public uiDialogAudio
{
    Q_OBJECT

public:
     DialogAudio ( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~DialogAudio ( );

    void initMe ( SourceFileInfo  *, SourceFileEntry *, QString & );
    void initMe ( SourceFileEntry * );
    void initMe ( DVDMenu * );
    void initAudioSource ( SourceFileEntry * );
    int  getSelectedNumber ( );
    void setTranscode ( TranscodeInterface * );
    TranscodeInterface *getTranscode ( );

protected slots:
    virtual void accept                ( );
    virtual void slotHelp              ( );
    virtual void slotAdd               ( );
    virtual void slotEdit              ( );
    virtual void slotDelete            ( );
    virtual void slotSetSelectedItem   ( );
    virtual void slotAudioEntryChanged ( int );
    virtual void slotTranscoding       ( bool );
    virtual void slotCurrentChanged    ( QListViewItem * );

private:
    void initAudioInfo    ( Audio * );
    void initAudioInfo    ( TranscodeInterface * );
    void initAudioInfo    ( SourceFileInfo * );
    void setAudioInfo     ( SourceFileInfo *, SourceFileInfo * );
    void removeAudioTrack ( SourceFileInfo *, int );
    QString showLanguageDialog   ( );
    bool    checkAudioNumber ( int );

private:
    QString m_qsFileName;
    SourceFileEntry  *m_pSourceFileEntry;
    SourceFileEntry  *m_pOrigSourceFileEntry;
    SourceFileInfo   *m_pSourceFileInfo;
    SourceFileInfo   *m_pOrigSourceFileInfo;
    QListViewItem    *m_pSelectItem;
    DVDMenu          *m_pDVDMenu;
};

#endif // DIALOGAUDIO_H
