/****************************************************************************
** Interface to the GUI.
**
**   Created : Tue 08 May 12:09:08 2004
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class will create a toolbar, which holds only one widget.
** The StructureWidget is displaying the current structure of the DVD.
**
****************************************************************************/

#ifndef COLORTOOLBAR_H
#define COLORTOOLBAR_H

#include <qtoolbar.h>
#include <qsize.h>

#include "rgba.h"

class QListView;

class DVDMenu;

class QColorFrame : public QFrame
{
  Q_OBJECT
public:
  QColorFrame ( int, Rgba, QWidget *p=0, const char *n=0, WFlags f=0 );
  virtual ~QColorFrame ( );

  Rgba getColor   ( );
  void setColor   ( Rgba );

signals:
  void signalRightButtonClicked (int);

protected:
  // Overloaded member function ...
  virtual void mouseReleaseEvent (QMouseEvent *);
  virtual void paintEvent        (QPaintEvent *);

private:
  int  m_iWhichColor;
  Rgba m_color;
};


class ColorToolBar : public QToolBar
{
  Q_OBJECT

public:
  ColorToolBar ( const char *, QMainWindow * );
  virtual ~ColorToolBar ( );

  Rgba getColor   ( uint );
  void setColor   ( uint, Rgba );
  void setDVDMenu ( DVDMenu  * );

protected slots:
  virtual void slotColorClicked ( int );


private:
	QColorFrame *m_colorFrames[4];
	DVDMenu     *m_pCurrentDVDMenu;
};

#endif // COLORTOOLBAR_H


