/****************************************************************************
** Run - class
**
** Created: Fri Aug 3 12:09:08 2007
**      by: Varol Okan using XEmacs
**
** This class will spawn a new process through fork() and run a command
** The output to stdout is then read in by the parent thread.
** Once the child thread terminates the parent continues.
**
** This class was required after QProcess failed to work propperly during
** the initialization of a QDialog derived class due to the EventLoop not
** yet running.
** 
****************************************************************************/

#ifndef __RUN_H__
#define __RUN_H__

#include <qstringlist.h>

class Run
{
 public:
           Run ( );
  virtual ~Run ( );

  // Keep the interface very similar to QProcess 
  // to keep the current implementation working
  void setArguments   ( QStringList & );
  void setCommand     ( QString & );

  void tryTerminate   ( );
  void kill           ( );

  bool started        ( );
  bool finished       ( );

  virtual int  start  ( QStringList *pEnv=0 );

  // Pure virtual function to handle output
  virtual void stdOut ( QString & ) = 0;

 protected:
  QString m_qsCommand;
  int     m_iChildPID;
  bool    m_bStarted;
  bool    m_bFinished;
};

#endif	// __RUN_H__

