/****************************************************************************
** assignmenuaudio.cpp
**
**   Created : May 4 2008
**        by : Varol Okan using Kate
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
*****************************************************************************/

#include <qfileinfo.h>
#include <qlistview.h>
#include <qcombobox.h>
#include <qpushbutton.h>

#include "utils.h"
#include "global.h"
#include "qdvdauthor.h"
#include "assignmenuaudio.h"
#include "filepreviewdialog.h"

namespace Input
{

AssignMenuAudio::AssignMenuAudio ( QWidget* parent, const char* name, bool modal, WFlags fl )
  : uiAssignMenuAudio ( parent, name, modal, fl )
{
  connect ( m_pButtonAdd,    SIGNAL ( clicked ( ) ), this, SLOT ( slotAdd    ( ) ) );
  connect ( m_pButtonDelete, SIGNAL ( clicked ( ) ), this, SLOT ( slotDelete ( ) ) );
  connect ( m_pButtonCancel, SIGNAL ( clicked ( ) ), this, SLOT ( reject     ( ) ) );
  connect ( m_pButtonOkay,   SIGNAL ( clicked ( ) ), this, SLOT ( accept     ( ) ) );

  QString qsText, qsCode;
  QString qsLang = "something";
  Utils theUtils;
  int t = 0;

  while ( ! qsLang.isEmpty ( ) ) {
    qsLang = theUtils.iso639 ( qsText, false, t++ );
    m_pComboLanguage->insertItem ( qsLang );
  }
  m_pComboLanguage->setCurrentText ( "English" );

}

/*
 *  Destroys the object and frees any allocated resources
 */
AssignMenuAudio::~AssignMenuAudio ( )
{
}

void AssignMenuAudio::slotAdd ( )
{
  QStringList listFileNames;
  QString   qsFilter       = Global::pApp->getSoundFilter ( );
  QString   qsDialogFilter = tr ("Sound Files (") + qsFilter + QString(")");

  listFileNames = FilePreviewDialog::getOpenFileNames ( Global::qsCurrentPath, QString::null, NULL, "SoundFilesDialog", tr( "Select sound files" ), &qsDialogFilter );

  if ( listFileNames.count ( ) < 1)
    return;

  QFileInfo fileInfo;
  QStringList::iterator it = listFileNames.begin ( );
  while ( it != listFileNames.end ( ) )  {
    fileInfo.setFile ( *it++ );

    //QListViewItem *pItem = 
    new QListViewItem ( m_pListAudio, fileInfo.extension ( FALSE ).lower ( ), "yes", fileInfo.filePath ( ) );
  }
}

void AssignMenuAudio::slotDelete ( )
{
  QListViewItem *pItem, *pNextItem;
  pItem = m_pListAudio->firstChild ( );
  while ( pItem )  {
    pNextItem = pItem->nextSibling ( );
    if  ( pItem->isSelected ( ) )
      delete pItem;
    pItem = pNextItem;
  }
}

}; // end of namespace Input
