/****************************************************************************
** Interface to the GUI.
**
**   Created : Sun Feb 23 21:45:00 2004
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
** License   : GPL v 2.0
**
**  pure virtual class as base for the three button types.
**
****************************************************************************/

#ifndef TEXTOBJECT_H
#define TEXTOBJECT_H

#include <qobject.h>
#include "menuobject.h"

class QPopupMenu;

class TextObject : public MenuObject
{
	Q_OBJECT
public:
	TextObject (QWidget *pParent = 0);
	virtual ~TextObject ();
	virtual void drawContents          ( QPainter * );
	virtual void drawContents          ( QPainter *, int , int );
	virtual bool mousePressEvent       ( QMouseEvent * );
	virtual bool mouseReleaseEvent     ( QMouseEvent * );
	virtual bool mouseDoubleClickEvent ( QMouseEvent * );

	virtual bool readProjectFile       ( QDomNode      & );
	virtual bool writeProjectFile      ( QDomElement   & );
	virtual bool createContextMenu     ( QPoint );
	virtual StructureItem *createStructure ( StructureItem * );
	virtual MenuObject    *clone       ( QWidget *p1=NULL, MenuObject *p2=NULL );
	virtual void replaceColor          ( Rgba, Rgba );

	virtual void setFont               ( QFont   & );
	virtual void setText               ( QString & );
	virtual void setTextAlign          ( QPoint  & );
	virtual void setWordBreak          ( bool );
	virtual void setStyleStrategy      ( int  );
	virtual void setForegroundColor    ( const Rgba & );
	virtual void setBackgroundColor    ( const Rgba & );
	virtual QFont   &getFont           ( );
	virtual QString &getText           ( );
	virtual QPoint  &getTextAlign      ( );
	virtual int      getStyleStrategy  ( );
	virtual Rgba    &getForegroundColor( );
	virtual Rgba    &getBackgroundColor( );

private:
	void drawSemiTransparent           ( QPainter * );

protected:
	virtual AnimationAttribute *getSpecificAttributes (long, QString);

public slots:
	virtual void slotEdit              ( );
	virtual void slotMatrix            ( );
	virtual void slotAddFrame          ( );
	virtual void slotAddImage          ( );
	virtual void slotAddMovie          ( );
	virtual void slotDefineAsButton    ( );

protected:
	QString     m_qsText;
	QFont       m_Font;
	QPoint      m_ptTextAlign;
	Rgba        m_colorForeground;
	Rgba        m_colorBackground;
	int         m_iStyleStrategy;
	bool        m_bAllowWordBreak; // don't need ot be stored. Only set after DialogTextFont
};


#endif	// TEXTOBJECT_H
