
// This is the implementation of the ComplexDVD plugin for QDVDAuthor.

#include <stdlib.h>

#include <qprogressdialog.h>
#include <qapplication.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qfileinfo.h>
#include <qlayout.h>
#include <qcursor.h>

#include "uisimpledvd.h"
#include "simpledvd.h"

// The class factories
extern "C"  Plugin::Interface *createPlugin ( ) {
    return new Plugin::ComplexDVD;
}
extern "C" void destroyPlugin ( Plugin::Interface *pDeleteMe ) {
    delete pDeleteMe;
}

#ifndef PREFIX
#define PREFIX "/usr"
#endif

namespace Plugin
{

ComplexDVD::ComplexDVD ( )
{
  m_iNrOfMenus    = 0;
  m_pConfigWidget = NULL;
  m_qsPluginName  = "ComplexDVD" + QString ( " -%1-" ).arg ( getPluginVersion ( ), 0, 'f', 2 );
}

ComplexDVD::~ComplexDVD ( )
{
  if ( m_pConfigWidget )
    delete m_pConfigWidget;
  m_pConfigWidget = NULL;
}

QWidget *ComplexDVD::getConfigWidget ( QWidget *pParent )
{
  // Note this widget has to be destroyed in the library
  m_pConfigWidget = new uiControls ( pParent );
  return m_pConfigWidget;
}

void ComplexDVD::getRandomBackground ( )
{
  // gets random images off of InterFaceLift.com and stores them in /tmp
  int iOffset = 1;
  QString qsCommand, qsTempPath;
  qsTempPath = m_qsTempPath + "/" + m_qsProjectName;

  QDialog   progressDialog    ( NULL );
  QGridLayout  progressLayout ( &progressDialog );
  QProgressBar progressBar    ( &progressDialog );
  progressLayout.addWidget    ( &progressBar, 0, 0 );
  progressDialog.resize       ( QSize(550, 50).expandedTo ( progressDialog.minimumSizeHint ( ) ) );
  progressDialog.setCaption   ( tr ( "Receiving random images." ) );
  progressDialog.show         ( );
  progressBar.setTotalSteps   ( m_iNrOfMenus );
  qApp->processEvents         ( 100 );

  if ( m_pConfigWidget && m_pConfigWidget->m_pCheckMainMenu && 
       m_pConfigWidget->m_pCheckMainMenu->isChecked ( ) )
    iOffset ++;

  qsCommand = QString ( "rm %1/menu_*.jpg 2>&1 >/dev/null" ).arg ( qsTempPath );
  system ( qsCommand.ascii ( ) );

  for ( int t=0; t<m_iNrOfMenus; t++ )  {
    qsCommand=QString ( "POTD=`wget -qO - 'interfacelift.com/wallpaper/index.php?sort=random&aspect=&widescreen&w=1280&h=800' | grep \"download</a>\" | sed -e \"s,.*href=\\\",,\" -e \"s,\\\",,\" | awk 'NR==\"3\" {print}' | awk '{ gsub(/dl\\/wallpaper\\//,\"\");gsub(/>download<\\/a>/,\"\");print}'`; wget -q -O \"%1/menu_%2.jpg\"  interfacelift.com/wallpaper/downloads$POTD" ).arg ( qsTempPath ).arg ( t + iOffset );
    progressDialog.show     ( ); // why does this dlg disappear ? 
    progressDialog.raise    ( );
    progressBar.setProgress ( t + iOffset );
    qApp->processEvents     ( 10 );

//printf ( "%s\n", qsCommand.ascii ( ) );
    system ( qsCommand.ascii ( ) );
  }
}

void ComplexDVD::createMainMenu ( )
{
  // creates a MainMenu with only one Button to the next Menu.
  // This is for the user to fill in 
  SourceGroup::type theType = SourceGroup::NTSC; // pGroup->enType;
  QString qsMenuName = QString ( "Menu 1" ); // this will be converted to VMGM due to the 1
  QString qsMenuXML, qsCommand, qsMenuBackground;

  qsMenuBackground = m_qsTempPath + "/" + m_qsProjectName + "/MainMenu.jpg";
  qsCommand = QString ( "rm \"%1\"" ).arg ( qsMenuBackground );
  system ( qsCommand.ascii ( ) );

  qsCommand=QString ( "POTD=`wget -qO - 'interfacelift.com/wallpaper/index.php?sort=random&aspect=&widescreen&w=1280&h=800' | grep \"download</a>\" | sed -e \"s,.*href=\\\",,\" -e \"s,\\\",,\" | awk 'NR==\"3\" {print}' | awk '{ gsub(/dl\\/wallpaper\\//,\"\");gsub(/>download<\\/a>/,\"\");print}'`; wget -q -O \"%1\"  interfacelift.com/wallpaper/downloads$POTD" ).arg ( qsMenuBackground );
//printf ( "%s\n", qsCommand.ascii ( ) );
  system ( qsCommand.ascii ( ) );

  qsMenuXML += "<MainVMGM MenuWidth=\"720\" TitlesetNr=\"0\" MenuHeight=\"480\" MenuFormat=\"1\" MenuRatio=\"4:3\" MenuNr=\"0\" >\n";
  qsMenuXML += "  <MenuVariables>\n";
  qsMenuXML += "   <MenuOffset>00:00:00.000</MenuOffset>\n";
  qsMenuXML += "   <MenuDuration>00:00:01.000</MenuDuration>\n";
  qsMenuXML += "   <MenuBackground ResizeAlgo=\"Normal Qt\" OffsetX=\"0\" OffsetY=\"0\" StretchType=\"0\" >"+qsMenuBackground+"</MenuBackground>\n";
  qsMenuXML += "   <MenuName>Main Menu VMGM</MenuName>\n";
  qsMenuXML += "   <MaskColors>#00fefffe,#fffa9632,#ffff1414,#ffffff14,</MaskColors>\n";
  qsMenuXML += "  </MenuVariables>\n";
  qsMenuXML += "  <PreviewVariables>\n";
  qsMenuXML += "   <ButtonObject Action=\"jump+-+Menu 2+-+\" PreAction=\"\" ButtonName=\"Button 1\" >\n";
  qsMenuXML += "    <NormalState>\n";
  qsMenuXML += "     <TextObject BackgroundColor=\"#ffffe866\" TextAlign=\"4,64\" ForegroundColor=\"#ffff1437\" Font=\"Courier,26,-1,5,75,0,0,0,0,0\" Text=\"First Menu\" >\n";
  qsMenuXML += "      <MenuObject Width=\"231\" X=\"257\" Y=\"210\" Height=\"45\" ObjectName=\"First Menu\" />\n";
  qsMenuXML += "     </TextObject>\n";
  qsMenuXML += "    </NormalState>\n";
  qsMenuXML += "    <SelectedState>\n";
  qsMenuXML += "     <TextObject StyleStrategy=\"256\" TextAlign=\"4,64\" ForegroundColor=\"#ffff1414\" Font=\"Courier,26,-1,5,75,0,0,0,0,0\" Text=\"First Menu\">\n";
  qsMenuXML += "      <MenuObject Width=\"231\" X=\"257\" Y=\"210\" Height=\"45\" ObjectName=\"First Menu\" />\n";
  qsMenuXML += "     </TextObject>\n";
  qsMenuXML += "    </SelectedState>\n";
  qsMenuXML += "    <HighlightedState>\n";
  qsMenuXML += "     <TextObject StyleStrategy=\"256\" TextAlign=\"4,64\" ForegroundColor=\"#fffa9632\" Font=\"Courier,26,-1,5,75,0,0,0,0,0\" Text=\"First Menu\">\n";
  qsMenuXML += "      <MenuObject Width=\"231\" X=\"257\" Y=\"210\" Height=\"45\" ObjectName=\"First Menu\" />\n";
  qsMenuXML += "     </TextObject>\n";
  qsMenuXML += "    </HighlightedState>\n";
  qsMenuXML += "    <MenuObject Width=\"231\" X=\"257\" Y=\"210\" Height=\"45\" ObjectName=\"Button 1\" />\n";
  qsMenuXML += "   </ButtonObject>\n";
  qsMenuXML += "  </PreviewVariables>\n";
  qsMenuXML += " </MainVMGM>\n";

  emit ( signalNewMenuResponse ( theType, qsMenuName, qsMenuXML ) );
}

bool ComplexDVD::execute ( )
{
  int iButtonsPerMenu = 6;
  // Here we create the DVD Structure for the given input arameters
  QValueList<SourceGroup *>::iterator it = m_listOfGroups.begin ( );
  SourceGroup *pGroup = NULL;
  int iMenuNumber, iCount;
  iMenuNumber = iCount = 0;
  // First we should add the Groups ( SourceFIleEntries ...
  while ( it != m_listOfGroups.end ( ) )  {
    pGroup = *it++;
    emit ( signalNewSource ( pGroup ) );
  }

  QCursor myCursor ( QCursor::WaitCursor );
  QApplication::setOverrideCursor ( myCursor );

  // The next iteration we generate the DVDMenus.
  m_iNrOfMenus  = (int)( ( m_listOfGroups.count ( ) + iButtonsPerMenu - 1 ) / iButtonsPerMenu );

  // Here we eval if we should snap some random images off of ImageFaceLift.com
  if ( m_pConfigWidget && m_pConfigWidget->m_pCheckInterFaceLift && 
       m_pConfigWidget->m_pCheckInterFaceLift->isChecked ( ) )
    getRandomBackground ( );
  if ( m_pConfigWidget && m_pConfigWidget->m_pCheckMainMenu && 
       m_pConfigWidget->m_pCheckMainMenu->isChecked ( ) )  {
    createMainMenu ( );
    iMenuNumber ++;
  }

  int iProgress = 0;
  QDialog   progressDialog    ( NULL );
  QGridLayout  progressLayout ( &progressDialog );
  QProgressBar progressBar    ( &progressDialog );
  progressLayout.addWidget    ( &progressBar, 0, 0 );
  progressDialog.resize       ( QSize(550, 50).expandedTo ( progressDialog.minimumSizeHint ( ) ) );
  progressDialog.setCaption   ( tr ( "Creating [Menu 1]" ) );
  progressDialog.show         ( );
  progressBar.setTotalSteps   ( (int)m_listOfGroups.count ( ) );
  progressBar.setProgress     ( iProgress++  );
  qApp->processEvents         ( 500 );

  QValueList<SourceGroup *> listGroups;
  it = m_listOfGroups.begin  ( );
  while ( it != m_listOfGroups.end  ( ) )  {
    pGroup = *it++;
    // Next we create the Menus required ...
    // The number of menus depends on the max number of buttons per menu ( m_iButtonsPerMenu )
    listGroups.append ( pGroup );
    if ( iCount++ >= iButtonsPerMenu - 1 )  {
      SourceGroup::type theType = pGroup->enType;
      QString qsMenuXML = getMenuXML ( listGroups, ++iMenuNumber );
      listGroups.clear ( );

      QString qsMenuName = QString ( "Menu %1" ).arg ( iMenuNumber );
      progressDialog.setCaption ( tr ( "Creating [%1]" ).arg ( qsMenuName ) );

      // Create the DVDMenu
      emit ( signalNewMenuResponse ( theType, qsMenuName, qsMenuXML ) );
      iCount = 0;
    }
    progressBar.setProgress ( iProgress++ );
    qApp->processEvents     ( 10 );
  }
  if ( iCount > 0 )  {
      SourceGroup::type theType = pGroup->enType;
      QString qsMenuName, qsMenuXML;
      qsMenuName.sprintf ( "Menu %d", ++iMenuNumber );
      qsMenuXML = getMenuXML ( listGroups, iMenuNumber );
      listGroups.clear ( );

      // Create the DVDMenu
      //printf ( "%s\n\n\n", qsMenuXML.ascii ( ) );
      emit ( signalNewMenuResponse ( theType, qsMenuName, qsMenuXML ) );
  }
  QApplication::restoreOverrideCursor ( );
  return true;
}

QString ComplexDVD::getMenuXML ( QValueList<SourceGroup *> &list, int iMenuNumber )
{
  QFileInfo fileInfo;
  QString qsMenuXML, qsBackgroundFile, qsMenuName, qsFileName;
  QString qsHeight = "480";
  QString qsButtonName, qsFrameName, qsObjectName, qsJumpTo, qsX, qsY, qsTempPath;
  int iCount = 0;
  SourceGroup *pGroup = NULL;
  if ( list.count ( ) < 1 )
    return qsMenuXML;

  qsTempPath = m_qsTempPath + "/" + m_qsProjectName;
  qsBackgroundFile = PREFIX"/share/qdvdauthor/plugins/simpledvd/background.jpg";
  if ( m_pConfigWidget && m_pConfigWidget->m_pCheckInterFaceLift && 
       m_pConfigWidget->m_pCheckInterFaceLift->isChecked ( ) )
    qsBackgroundFile = QString ( "%1/menu_%2.jpg" ).arg ( qsTempPath ).arg ( iMenuNumber );

  qsMenuName.sprintf ( "Menu %d", iMenuNumber );
  pGroup = list[0];
  if ( pGroup->enType == SourceGroup::PAL )
    qsHeight = "576";

  qsMenuXML += " <DVDMenu MenuWidth=\"720\" MenuHeight=\""+qsHeight+"\" MenuFormat=\"0\" MenuRatio=\"4:3\" >\n";
  qsMenuXML += "  <MenuVariables>\n";
  qsMenuXML += "   <MenuOffset>00:00:00.000</MenuOffset>\n";
  qsMenuXML += "    <MenuDuration>00:00:01.000</MenuDuration>\n";
  qsMenuXML += "   <MenuBackground ResizeAlgo=\"Normal Qt\" OffsetX=\"0\" OffsetY=\"0\" StretchType=\"2\" >"+qsBackgroundFile+"</MenuBackground>\n";
  qsMenuXML += "   <MenuName>"+qsMenuName+"</MenuName>\n";
  qsMenuXML += "   <MaskColors>#00fefffe,#fffa9632,#ffff1414,#ffffff14,</MaskColors>\n";
  qsMenuXML += "  </MenuVariables>\n";
  qsMenuXML += "  <PreviewVariables>\n";

  // Transparent area - Top
  qsMenuXML += "   <TextObject BackgroundColor=\"#ffaaff5a\" TextAlign=\"4,64\" ForegroundColor=\"#fff15735\" Font=\"Sans Serif,20,-1,5,75,0,0,0,0,0\" Text=\"\" >\n";
  qsMenuXML += "    <MenuObject Width=\"740\" X=\"0\" Y=\"35\" Height=\"150\" ObjectName=\"\" >\n";
  qsMenuXML += "     <Modifiers Transparency=\"0.60\" />\n";
  qsMenuXML += "    </MenuObject>\n";
  qsMenuXML += "   </TextObject>\n";

  // Transparent area - Bottom
  qsMenuXML += "   <TextObject BackgroundColor=\"#fff4f5f4\" TextAlign=\"4,64\" ForegroundColor=\"#ff000000\" Font=\"Courier,12,-1,5,50,0,0,0,0,0\" Text=\"\" >\n";
  qsMenuXML += "    <MenuObject Width=\"740\" X=\"-8\" Y=\"285\" Height=\"150\" ObjectName=\"\" >\n";
  qsMenuXML += "     <Modifiers Transparency=\"0.60\" />\n";
  qsMenuXML += "    </MenuObject>\n";
  qsMenuXML += "   </TextObject>\n";

  // Next we take care of the Buttons ...
  QValueList<SourceGroup *>::iterator it;
  it = list.begin ( );
  while ( it != list.end ( ) )  {
    pGroup = *it++;

    if ( ! pGroup )
       continue;
    qsFileName = "";
    if ( pGroup->listFiles.size ( ) > 0 )  {
      fileInfo.setFile ( pGroup->listFiles[0]->qsFileName );
      qsFileName = fileInfo.fileName ( );
      if ( qsFileName.length ( ) > 0 )
        qsFileName += "+-+00:00:00.000";
    }
//jump+-+[01] - cordes.mpg+-+001_capture001.mpeg+-+00:00:00.000
    qsJumpTo = QString ( "jump+-+%1+-+%2" ).arg ( pGroup->qsGroupName ).arg ( qsFileName );
    qsButtonName  = QString ( "Button %1" ).arg ( ++iCount );
    qsObjectName  = QString ( "Object_%1" ).arg (   iCount );
    qsFrameName   = QString ( "Frame %1"  ).arg (   iCount );
    qsX = QString( "%1" ).arg (( iCount-1 )%3 * 210 + 90 );
    qsY = ( iCount > 3 ) ? "400" : "150";

    // First we create the assiciated TextObject
    qsMenuXML += "   <TextObject TextAlign=\"4,64\" ForegroundColor=\"#fff15735\" Font=\"Sans Serif,16,-1,5,75,0,0,0,0,0\" Text=\""+pGroup->qsGroupName+"\" >\n";
    qsMenuXML += "    <MenuObject Width=\"150\" X=\""+qsX+"\" Y=\""+qsY+"\" Height=\"41\" ObjectName=\""+pGroup->qsGroupName+"\" />\n";
    qsMenuXML += "   </TextObject>\n";

    qsY = ( iCount > 3 ) ? "295" : "45";

    // Next we create the ButtonObject for the video jump+-+vmgm+-+
    qsMenuXML += "   <ButtonObject Action=\""+qsJumpTo+"\" ButtonName=\""+qsButtonName+"\" >\n";
    qsMenuXML += "    <NormalState>\n";
    qsMenuXML += "     <ImageObject FileName=\""+pGroup->qsScreenshot+"\" >\n";
    qsMenuXML += "      <Manipulator>\n";
    qsMenuXML += "       <Modifiers/>\n";
    qsMenuXML += "      </Manipulator>\n";
    qsMenuXML += "      <MenuObject Width=\"150\" X=\""+qsX+"\" Y=\""+qsY+"\" Height=\"115\" ObjectName=\""+qsObjectName+"\" ObjectExtractionPath=\""+qsObjectName+"\" />\n";
    qsMenuXML += "     </ImageObject>\n";
    qsMenuXML += "    </NormalState>\n";

    qsMenuXML += "    <SelectedState>\n";
    qsMenuXML += "     <FrameObject Width=\"10\" Color=\"#ffff1414\" >\n";
    qsMenuXML += "      <MenuObject Width=\"150\" X=\""+qsX+"\" Y=\""+qsY+"\" Height=\"112\" ObjectName=\""+qsFrameName+"\" />\n";
    qsMenuXML += "     </FrameObject>\n";
    qsMenuXML += "    </SelectedState>\n";
    qsMenuXML += "    <HighlightedState>\n";
    qsMenuXML += "     <FrameObject Width=\"10\" Color=\"#fffa9632\" >\n";
    qsMenuXML += "      <MenuObject Width=\"150\" X=\""+qsX+"\" Y=\""+qsY+"\" Height=\"112\" ObjectName=\""+qsFrameName+"\" />\n";
    qsMenuXML += "     </FrameObject>\n";
    qsMenuXML += "    </HighlightedState>\n";
    qsMenuXML += "    <MenuObject Width=\"150\" X=\""+qsX+"\" Y=\""+qsY+"\" Height=\"112\" ObjectName=\""+qsButtonName+"\" />\n";
    qsMenuXML += "   </ButtonObject>\n";
  }
  // Create prev/next buttons
  bool bPrev = ( iMenuNumber > 1 );
  bool bNext = ( iMenuNumber < m_iNrOfMenus );
  qsMenuXML += getMenuButtons ( bPrev, bNext, iMenuNumber );

  qsMenuXML += "  </PreviewVariables>\n";
  qsMenuXML += " </DVDMenu>\n";

  return qsMenuXML;
}

QString ComplexDVD::getMenuButtons ( bool bPrev, bool bNext, int iMenuNumber )
{
  QString qsMenuXML, qsMenuName;
  // The three buttons to the previous, next and Main menu ...
  QString qsButtonPrev = PREFIX"/share/qdvdauthor/plugins/simpledvd/prev.png";
  QString qsButtonMain = PREFIX"/share/qdvdauthor/plugins/simpledvd/main.png";
  QString qsButtonNext = PREFIX"/share/qdvdauthor/plugins/simpledvd/next.png";
  if ( bPrev )  {
    qsMenuName = QString ( "Menu %1" ).arg ( iMenuNumber - 1 );
    qsMenuXML += "   <ButtonObject Action=\"jump+-+"+qsMenuName+"+-+\" ButtonName=\"Button 7\" >\n";
    qsMenuXML += "    <NormalState>\n";
    qsMenuXML += "     <ImageObject FileName=\""+qsButtonPrev+"\" >\n";
    qsMenuXML += "      <Manipulator>\n";
    qsMenuXML += "       <Modifiers/>\n";
    qsMenuXML += "       <ColorKey Color=\"#fffefffe\" />\n";
    qsMenuXML += "      </Manipulator>\n";
    qsMenuXML += "      <MenuObject Width=\"60\" X=\"253\" Y=\"212\" Height=\"45\" ObjectName=\"PrevImg\" ObjectExtractionPath=\"PrevImg\" />\n";
    qsMenuXML += "     </ImageObject>\n";
    qsMenuXML += "    </NormalState>\n";
    qsMenuXML += "    <SelectedState>\n";
    qsMenuXML += "     <MaskObject Color=\"#a0ff1414\" />\n";
    qsMenuXML += "    </SelectedState>\n";
    qsMenuXML += "    <HighlightedState>\n";
    qsMenuXML += "     <MaskObject Color=\"#a0fa9632\" />\n";
    qsMenuXML += "    </HighlightedState>\n";
    qsMenuXML += "    <MenuObject Width=\"60\" X=\"253\" Y=\"212\" Height=\"45\" ObjectName=\"ButtonPrev\" />\n";
    qsMenuXML += "   </ButtonObject>\n";
  }
  if ( bNext )  {
    qsMenuName = QString ( "Menu %1" ).arg ( iMenuNumber + 1 );
    qsMenuXML += "   <ButtonObject Action=\"jump+-+"+qsMenuName+"+-+\" ButtonName=\"Button 8\" >\n";
    qsMenuXML += "    <NormalState>\n";
    qsMenuXML += "     <ImageObject FileName=\""+qsButtonNext+"\" >\n";
    qsMenuXML += "      <Manipulator>\n";
    qsMenuXML += "       <Modifiers/>\n";
    qsMenuXML += "       <ColorKey Color=\"#fffefffe\" />\n";
    qsMenuXML += "      </Manipulator>\n";
    qsMenuXML += "      <MenuObject Width=\"60\" X=\"378\" Y=\"213\" Height=\"45\" ObjectName=\"NextImg\" ObjectExtractionPath=\"NextImg\" />\n";
    qsMenuXML += "     </ImageObject>\n";
    qsMenuXML += "    </NormalState>\n";
    qsMenuXML += "    <SelectedState>\n";
    qsMenuXML += "     <MaskObject Color=\"#a0ff1414\" />\n";
    qsMenuXML += "    </SelectedState>\n";
    qsMenuXML += "    <HighlightedState>\n";
    qsMenuXML += "     <MaskObject Color=\"#a0fa9632\" />\n";
    qsMenuXML += "    </HighlightedState>\n";
    qsMenuXML += "    <MenuObject Width=\"60\" X=\"378\" Y=\"213\" Height=\"45\" ObjectName=\"ButtonNext\" />\n";
    qsMenuXML += "   </ButtonObject>\n";
  }
  // Button to the Main Menu ..
  qsMenuXML += "   <ButtonObject Action=\"jump+-+vmgm+-+\" ButtonName=\"Button 9\" >\n";
  qsMenuXML += "    <NormalState>\n";
  qsMenuXML += "     <ImageObject FileName=\""+qsButtonMain+"\" >\n";
  qsMenuXML += "      <Manipulator>\n";
  qsMenuXML += "       <Modifiers/>\n";
  qsMenuXML += "       <ColorKey Color=\"#fffefffe\" />\n";
  qsMenuXML += "      </Manipulator>\n";
  qsMenuXML += "      <MenuObject Width=\"60\" X=\"315\" Y=\"206\" Height=\"56\" ObjectName=\"MainImg\" ObjectExtractionPath=\"MainImg\" />\n";
  qsMenuXML += "     </ImageObject>\n";
  qsMenuXML += "    </NormalState>\n";
  qsMenuXML += "    <SelectedState>\n";
  qsMenuXML += "     <MaskObject Color=\"#a0ff1414\" />\n";
  qsMenuXML += "    </SelectedState>\n";
  qsMenuXML += "    <HighlightedState>\n";
  qsMenuXML += "     <MaskObject Color=\"#a0fa9632\" />\n";
  qsMenuXML += "    </HighlightedState>\n";
  qsMenuXML += "    <MenuObject Width=\"60\" X=\"315\" Y=\"206\" Height=\"56\" ObjectName=\"ButtonMain\" />\n";
  qsMenuXML += "   </ButtonObject>\n";

  return   qsMenuXML;
}

}; // end namespace Plugin

