/****************************************************************************
** OneClickWizard
**
**   Created : Tue Apr 23 12:09:08 2008
**        by : Varol Okan using Kate
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#ifndef ONECLICKWIZARD_H
#define ONECLICKWIZARD_H

#include "dialogfiles.h"
#include "plugins/interface.h"
#include "uioneclickwizard.h"

class QBoxLayout;
class QListBox;
class SourceFileEntry;
class CXmlSlideshow;

namespace Input
{

class OneClickWizard : public uiOneClickWizard
{
    Q_OBJECT

    class Group  {
    public:
      Group ( );
      CXmlSlideshow   *pSlideshow;
      SourceFileEntry *pSourceFileEntry;
    };

public:
    OneClickWizard ( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    virtual ~OneClickWizard ( );

    bool initMe ( );

protected:
    int  loadPlugins       ( QString & );
    QString uniqueGroupName( QString );
    void play              ( QString );
    bool loadPlugin        ( uint );
    void deleteGroups      ( );
    void unloadPlugin      ( );
    void checkControls     ( );
    GroupView *addGroup    ( SourceFileEntry * );
    void addSourceToGroup  ( GroupView       * );
    void toSourceGroup     ( );
    void groupsToPlugin    ( );

    void sourceFileToPlugin ( Plugin::SourceGroup *, SourceFileEntry * );
    void slideshowToPlugin  ( Plugin::SourceGroup *, CXmlSlideshow   * );

protected slots:
    virtual void accept             ( );
    virtual void slotHelp           ( );
    virtual void slotBrowseTemp     ( );
    virtual void slotBrowseDVD      ( );
    virtual void slotGroupUp        ( );
    virtual void slotGroupDown      ( );
    virtual void slotGroupDelete    ( );
    virtual void slotGroupRename    ( );
    virtual void slotAddVideos      ( );
    virtual void slotAddImages      ( );
    virtual void slotCurrentGroup   ( int  );
    virtual void slotChangePlugin   ( int  );
    virtual void slotCreateISO      ( bool );
    virtual void slotBurnDVD        ( bool );
    virtual void slotProjectName    ( const QString & );
    virtual void slotGroupContextMenu     ( QListViewItem *, const QPoint &, int );
    virtual void slotSourceToSourceGroup  ( QListBoxItem  * );

private:
    QStringList m_listOfPlugins;
    int         m_iCurrentPlugin;
    bool        m_bCanClose;
    bool        m_bChangeProjectPath;

    void       *m_pLibrary;
    destroy_t  *m_pDestroyFunction;
    QWidget    *m_pConfigWidget;
    QListBox   *m_pVirtualFolderDialog;
    QBoxLayout *m_pLayoutMain;
    Plugin::Interface  *m_pPlugin;

    QValueList<Group *> m_listOfGroups;
};

}; // end namespace Input

#endif // ONECLICKWIZARD_H
