/****************************************************************************
** Form implementation generated from reading ui file 'uidialoglibrary.ui'
**
**   Created : Sun Feb 18 09:13:25 2007
**        by : Varol Okan, using XEmacs
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#include <qdir.h>
#include <qtimer.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qfileinfo.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qiconview.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qapplication.h>
#include <qprogressbar.h>

#include "CONFIG.h"
#include "global.h"
#include "dialoglibrary.h"

bool DialogLibrary::m_bCreateButtonMask = true;

DialogLibrary::LibraryPart::LibraryPart ( QIconView *pView, QString qsPath )
{
  pIconView     = pView;
  qsLibraryPath = qsPath;
}

DialogLibrary::DialogLibrary ( QWidget *pParent, const char *pName, bool bModal, WFlags flags )
  : uiDialogLibrary ( pParent, pName, bModal, flags )
{
  initMe ( );
}

DialogLibrary::~DialogLibrary ( )
{
  int t;
  for ( t=0; t<(int)m_listLibrary.count ( ); t++ ) 
    delete m_listLibrary[t];
}

void DialogLibrary::initMe ( )
{
  // build all library tabs.
  int      t;
  QDir     theDir;
  QString  qsPrefixDir, qsDirName;
  QStringList listDirs, listFiles;

  qsPrefixDir = QString ("%1/share/qdvdauthor/buttons").arg ( PREFIX_DIRECTORY );
  if ( !  theDir.exists ( qsPrefixDir ) )
    return;

  m_iWidth  = 120;
  m_iHeight = 120;
  m_pCheckButtonMask->setChecked ( m_bCreateButtonMask );

  QWidget *pTab = m_pTabWidget->page ( 0 );
  while  ( pTab ) {
    delete pTab;
    pTab = m_pTabWidget->page ( 0 );
  }

  theDir.cd ( qsPrefixDir, TRUE );
  listDirs = theDir.entryList ( QDir::Dirs, QDir::Name );
  if ( listDirs.count ( ) < 3 ) // 3 = this dir / parent dir / background file
    return;

  // The following widgets will create th progress dialog on the fly.
  QDialog       progressDialog  ( NULL );
  QGridLayout  *pProgressLayout = new QGridLayout  ( &progressDialog ); //, 1, 1 ); //, 11, 6, "progressWidgetLayout" );
  QProgressBar *pProgressBar    = new QProgressBar ( &progressDialog );
  pProgressLayout->addWidget( pProgressBar, 0, 0 );
  progressDialog.resize( QSize(537, 50).expandedTo ( progressDialog.minimumSizeHint ( ) ) );
  progressDialog.show  ( );

  for ( t=0; t<(int)listDirs.count ( ); t++ )  {
    // Here we go through all directories 
    qsDirName = listDirs[t];
    if ( ( qsDirName == ".") || ( qsDirName == "..") )
      continue;
    
    progressDialog.setCaption ( tr ( "Creating preview for buttons : %1" ).arg ( listDirs[t] ) );

    // Next we need to get the file list of the found directory
    QString qsPath = qsPrefixDir + "/" + qsDirName;
    theDir.cd ( qsPath );
    listFiles = theDir.entryList ( QDir::Files, QDir::Name );
    createTab ( qsDirName, qsPath, listFiles );

    pProgressBar->setProgress ( (int)((float)t / listDirs.count ( ) * 100.0) );
    qApp->processEvents ( 100 ); // do some event processing ...
  }
  connect ( m_pButtonRefresh,   SIGNAL ( clicked ( ) ), this, SLOT ( slotRefresh ( ) ) );
  connect ( m_pCheckButtonMask, SIGNAL ( clicked ( ) ), this, SLOT ( slotChecked ( ) ) );
  QTimer::singleShot ( 200, this, SLOT ( slotAfterInit ( ) ) );
}

void DialogLibrary::createTab ( QString qsDirName, QString qsPath, QStringList &listFiles )
{
  int t;
  if ( listFiles.count ( ) < 1 )
    return;

  // Okay, ready to create the tab ... 
  QString qsFileName;
  QSize grid ( 10, 10 );
  QWidget     *pTab      = new QWidget     ( m_pTabWidget, "pTab" );
  QGridLayout *pLayout   = new QGridLayout ( pTab, 1, 1, 4, 2, "pLayout" );
  QIconView   *pIconView = new QIconView   ( pTab, "pIconViewLibrary" );
  LibraryPart *pNewPart  = new LibraryPart ( pIconView, qsPath );
  m_listLibrary.append ( pNewPart );

  pLayout->addWidget        ( pIconView,  0, 0 );
  pIconView->setAutoArrange ( true  );
  m_pTabWidget->insertTab   ( pTab,  qsDirName );

  for ( t=0; t<(int)listFiles.count ( ); t++ ) {
    qsFileName = qsPath + "/" + listFiles[t];
    QPixmap thePix;
    QImage  theImage ( qsFileName );

    if ( theImage.isNull ( ) )
      continue;
    /*
    QFileInfo fileInfo ( listFiles[t] );
    QString qs = qsPath + "/" + fileInfo.baseName ( ) + ".png";
    printf ( "<%s>\n", qs.ascii () );

    setTransparentColor     ( theImage );
    theImage.save ( qs, "PNG" );
    */
    if ( ( theImage.width ( ) > m_iWidth ) || ( theImage.height ( ) > m_iHeight ) )
      theImage = theImage.smoothScale ( m_iWidth, m_iHeight, QImage::ScaleMin );

    setTransparentColor     ( theImage );
    thePix.convertFromImage ( theImage );

    new QIconViewItem ( pIconView, listFiles[t], thePix );
  }

  pIconView->arrangeItemsInGrid ( grid, TRUE );
  pIconView->sort ( );
}

void DialogLibrary::slotAfterInit ( ) 
{
  // Somehow the first IconView does not arrange in a grid.
  // so we have to force it to arrange
  if ( m_listLibrary.count ( ) < 1 )
    return;

  QSize grid ( 10, 10 );
  LibraryPart *pLibraryPart = m_listLibrary [ 0 ];
  pLibraryPart->pIconView->sort ( true );
}

void DialogLibrary::slotChecked ( ) 
{
  m_bCreateButtonMask = m_pCheckButtonMask->isChecked ( );
}

void DialogLibrary::slotRefresh ( ) 
{
  bool bOkay;
  int t, iStretchMode;
  QDir         theDir;
  QString      qsFileName;
  QStringList  listFiles;
  QIconView   *pCurrentView = NULL;
  LibraryPart *pLibraryPart = NULL;
  int          iCurrentTab = m_pTabWidget->currentPageIndex ( );
  QSize        grid ( 10, 10 );
  if ( iCurrentTab <(int)m_listLibrary.count ( ) )
    pLibraryPart = m_listLibrary [ iCurrentTab ];

  if ( ! pLibraryPart )
    return;

  pCurrentView = pLibraryPart->pIconView;
  pCurrentView->clear ( );

  m_iWidth = m_pEditWidth->text ( ).toInt ( &bOkay );
  if ( ! bOkay )
    m_iWidth = 120;

  m_iHeight = m_pEditHeight->text ( ).toInt ( &bOkay );
  if ( ! bOkay )
    m_iHeight = 120;

  iStretchMode = m_pComboStretch->currentItem ( );
  if ( iStretchMode == 0 )
    iStretchMode = QImage::ScaleMin;
  else if ( iStretchMode == 1 )
    iStretchMode = QImage::ScaleMax;
  else if ( iStretchMode == 2 )
    iStretchMode = QImage::ScaleFree;

  theDir.cd ( pLibraryPart->qsLibraryPath );
  listFiles = theDir.entryList ( QDir::Files, QDir::Name );

  for ( t=0; t<(int)listFiles.count ( ); t++ ) {
    qsFileName = pLibraryPart->qsLibraryPath + "/" + listFiles[t];
    QPixmap thePix;
    QImage  theImage ( qsFileName );

    if ( theImage.isNull ( ) )
      continue;

    if ( ( theImage.width ( ) > m_iWidth ) || ( theImage.height ( ) > m_iHeight ) )
      theImage = theImage.smoothScale ( m_iWidth, m_iHeight, (QImage::ScaleMode)iStretchMode );

    setTransparentColor     ( theImage );
    thePix.convertFromImage ( theImage );

    new QIconViewItem ( pCurrentView, listFiles[t], thePix );
  }

  pCurrentView->arrangeItemsInGrid ( grid, TRUE );
}

void DialogLibrary::setTransparentColor ( QImage &theImage )
{
  // QPixmap do not handle transparency, so we replace the tranparent parts here with the
  // color designated to be transparent in QDVDAuthor.
  int x, y, iWidth, iHeight;
  QRgb thePixel;

  iWidth  = theImage.width  ( );
  iHeight = theImage.height ( );
  for ( y=0; y < iHeight; y++)	{
    for (x=0; x < iWidth; x++)	{
      thePixel = theImage.pixel ( x, y );
      if ( ( thePixel & 0xFF000000 ) < 0x10000000 ) // See if this pixel is marked transparent.
	theImage.setPixel ( x, y, (uint)qRgba ( TRANSPARENT_COLOR, 0 ) ); // Transparent Color
    }
  }
}

void DialogLibrary::accept ( )
{
  hide ( );
}
