/****************************************************************************
** DialogFiles
**
**   Created : December 2008
**        by : Varol Okan using XEmacs
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
****************************************************************************/

//#include <stdlib.h> // For system ( ... )
//#include <unistd.h>

//#include <qtimer.h>
#include <qcursor.h>
#include <qiconview.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qprogressbar.h>
#include <qapplication.h>

#include "global.h"
#include "qdvdauthor.h"
#include "dialogslide.h"
#include "dialogimages.h"
//#include "filepreviewdialog.h"

/*
#ifndef DEBUG_INFO
#define debug_cout printf
#else
void debug_cout(const char *, ...){};
#endif
*/

namespace Input
{

/****************************************************************
 **
 ** Here is the implemenation of the DialogImages - class
 ** Basically te same dialog but tailored to images / Slideshows
 ** for easy usage from within the OneClickDVD - intr=erface.
 **
 ****************************************************************/

DialogImages::DialogImages ( QWidget *pParent, const char *pName, WFlags f )
  : DialogFiles ( pParent, pName, f )
{
  initMe ( );
}

DialogImages::~DialogImages ( )
{
}

void DialogImages::initMe ( )
{
  m_pButtonEdit->setText ( "Edit" );
  QWidget *pGroupTab = m_pTabWidget->page ( 2 );
  if ( pGroupTab )
    m_pTabWidget->setTabLabel ( pGroupTab, QString ( "Slideshows" ) );
}

void DialogImages::slotEditGroup ( )
{
    CSlideDialog *m_pSlideDialog = new CSlideDialog;
    m_pSlideDialog->initMe ( this, Global::qsTempPath );

    m_pSlideDialog->show ( );
}

QValueList<CXmlSlideshow *> &DialogImages::getSlideshows ( )
{
  return m_listOfSlideshows;
}

QString DialogImages::getDirFilter ( )
{
  return Global::pApp->getImageFilter ( );
}

void DialogImages::load ( QStringList &list )
{
  float     fPos;
  QImage    theImage;
  QPixmap   thePixmap;
  QString   qsFileName, qsFile;
  QFileInfo fileInfo;
  QIconViewItem    *pItem    = NULL;
  //ThumbnailRequest *pRequest = NULL;

  if ( list.count ( ) < 1 ) {
    m_pButtonAutoGroup->setEnabled ( false );
    return;
  }
  m_pButtonAutoGroup->setEnabled ( true );

  QCursor myCursor ( QCursor::WaitCursor );
  QApplication::setOverrideCursor ( myCursor );

  m_iProgress = 0;
  m_pProgressBar->reset ( );
  m_pProgressBar->setTotalSteps ( list.count ( ) );

  Cache::Thumbs::Entry *pCache = NULL;
  // get the first frame as the initial thumbnail.
  QStringList::iterator it = list.begin ( );
  while ( it != list.end ( ) )  {
  //for ( t=0; t < list.count ( ); t++ ) {
    qsFileName = *it++; //list[t];
    fileInfo.setFile ( qsFileName );
    qsFile = fileInfo.fileName  ( );
    pItem  = new QIconViewItem ( m_pPreview );
    pItem->setKey ( qsFileName );

    theImage.load ( qsFileName );
    createPix ( &thePixmap, &theImage );

    // We could not find the information in the cache so we have to create it
    pItem->setPixmap ( thePixmap );
    setIconText      ( pItem );
  }
  m_pProgressBar->setProgress ( m_iProgress );
  QApplication::restoreOverrideCursor     ( );
}

/*
void DialogFiles::load ( QStringList &listOfVideos )
{
  uint      t;
  float     fPos;
  QImage    theImage;
  QPixmap   thePixmap;
  QString   qsFileName, qsFile;
  QFileInfo fileInfo;
  QIconViewItem    *pItem    = NULL;
  ThumbnailRequest *pRequest = NULL;

  if ( listOfVideos.count ( ) < 1 ) {
    m_pButtonAutoGroup->setEnabled ( false );
    return;
  }
  m_pButtonAutoGroup->setEnabled ( true );

  QCursor myCursor ( QCursor::WaitCursor );
  QApplication::setOverrideCursor ( myCursor );

  m_iProgress = 0;
  m_pProgressBar->reset ( );
  m_pProgressBar->setTotalSteps ( listOfVideos.count ( ) );
  // First we should remove outstanding tasks ...
  MediaCreator::unregisterFromMediaScanner ( this );

  theImage = QImage ( QImage ( ).fromMimeSource ( "please_wait.jpg" ) );
  createPix ( &thePixmap, &theImage );

  Cache::Thumbs::Entry *pCache = NULL;
  // get the first frame as the initial thumbnail.
  for ( t=0; t < listOfVideos.count ( ); t++ ) {
    qsFileName = listOfVideos[t];
    fileInfo.setFile ( qsFileName );
    qsFile = fileInfo.fileName  ( );
    pItem  = new  QIconViewItem ( m_pPreview ); //, qsFile+"\nXX:XX:XX" );
    pItem->setKey ( qsFileName ); // pItem->text will be changed after scan returns with a preview
    pCache = Global::pThumbsCache->find ( qsFileName );
    if ( pCache )  {
      Thumbs *pThumbs       = new Thumbs;
      pThumbs->pOwnerItem   = pItem;
      pThumbs->iNumberOfPix = pCache->iNumberOfThumbs;
      pThumbs->arrayOfPix   = new QPixmap *[pCache->iNumberOfThumbs];
      pThumbs->pCache       = pCache;
      if ( ! pCache->arrayOfThumbs )
             pCache->loadImages  ( );

      for ( uint i=0; i<pCache->iNumberOfThumbs; i++ ) {
        pThumbs->arrayOfPix[i] = new QPixmap;
        fPos = (float)i / (pThumbs->iNumberOfPix-1);
        createPix ( pThumbs->arrayOfPix[i], pCache->arrayOfThumbs[i], fPos, pCache->iStarRating );
      }
      addPlayButton ( pItem, pThumbs->arrayOfPix[0] );
      setIconText   ( pThumbs ); 
      //pItem->setText   ( qsFile + QString ( "\n" ) + pCache->qsLength );
      append ( pThumbs );
      m_iProgress++;
    }
    else  {
      // We could not find the information in the cache so we have to create it
      pItem->setPixmap ( thePixmap );
      setIconText      ( pItem );
      pRequest = new ThumbnailRequest ( this, pItem, qsFileName, m_iMultiThumbNumber );
      MediaCreator::registerWithMediaScanner ( pRequest );
    }
  }
  m_pProgressBar->setProgress ( m_iProgress );
  QApplication::restoreOverrideCursor     ( );
}
*/

}; // end namespace Input
