/****************************************************************************
** FilePreviewDialog - class
**
** Created: Tue Jan 05 22:06:51 2006
**      by: Varol Okan using XEmacs
**
**
**
****************************************************************************/

#include <qlayout.h>
#include <qpixmap.h>
#include <qimage.h>


extern bool qt_resolve_symlinks; // defined in qapplication.cpp

#include "qplayer/mediacreator.h"
#include "filepreviewdialog.h"

FilePreviewDialog::FilePreviewDialog ( void *pExistingEngine, QWidget *pParent )
  : QLabel ( pParent )
{
  m_pMediaInterface = MediaCreator::createPreferredWidget (this, "MediaWidget", pExistingEngine);
  QGridLayout *m_pVideoLayout = new QGridLayout (this, 1, 1, 4, 6, "MediaMainLayout");
  m_pVideoLayout->addWidget (m_pMediaInterface->getWidget(), 0, 0);
  
  m_pMediaInterface->initMediaEngine();
  setMinimumWidth( 120 );
}

FilePreviewDialog::~FilePreviewDialog()
{
  m_pMediaInterface->stop ( );
  delete m_pMediaInterface;
}

void FilePreviewDialog::previewUrl ( const QUrl &theUrl )
{
  //  setText ( theUrl.path () );
  static QString qsPath;

  if ( qsPath == theUrl.path () )
    return;

  if ( theUrl.path().right ( 1 ) == "/" )
    return;
  //printf ("FilePreviewDialog::previewUrl <%s> vs qsPAth=<%s>\n", theUrl.path ().ascii (), qsPath.ascii() );
  qsPath = theUrl.path ();

  QImage theImage ( qsPath );
  if ( ! theImage.isNull () ) {
    QPixmap thePixmap;
    m_pMediaInterface->stop ( );
    m_pMediaInterface->getWidget ()->hide ();
    theImage = theImage.smoothScale ( width (), height (), QImage::ScaleMin );
    thePixmap.convertFromImage ( theImage );
    setPixmap ( thePixmap );
  }
  else {
    setText ( "." );
    m_pMediaInterface->getWidget ( )->show ( );
    m_pMediaInterface->playMRL   (  qsPath   );
    m_pMediaInterface->setVolume    ( 0.1 );
  }
}

QStringList FilePreviewDialog::getOpenFileNames ( void *pExistingEngine, const QString &qsStartIn, const QString &qsFilter, QWidget *pParent, const char *pName, const QString &qsCaption, QString *pSelectedFilter, bool bResolveSymlinks )
{
  //////////////////////////////////////////////////////////////////////
  // This function mimics the QFileDialog::getOpenFileName function.  //
  // I implemented here again for two main reasons.                   // 
  // 1) I can create a preview for Video streams / Image files        //
  // 2) In SuSE 10.x the getOpenFile function was acting weired       //
  //    and using KDEs FileOpen Dialog with the max Screen extension. //
  //////////////////////////////////////////////////////////////////////
  QStringList listOfFile;

  FilePreviewDialog *pPreview = new FilePreviewDialog ( pExistingEngine );
  QFileDialog *pDialog = new QFileDialog ( qsStartIn, QString::null, pParent, pName, false );// true );

  bool save_qt_resolve_symlinks = qt_resolve_symlinks;
  qt_resolve_symlinks = bResolveSymlinks;

  if ( pSelectedFilter )
    pDialog->setFilter               ( *pSelectedFilter );

  pDialog->setMode                   ( QFileDialog::ExistingFiles );
  pDialog->setContentsPreviewEnabled ( true );
  pDialog->setContentsPreview        ( pPreview, pPreview );
  pDialog->setPreviewMode            ( QFileDialog::Contents );
  pDialog->setCaption                ( qsCaption );

  pDialog->layout ()->setResizeMode  ( QLayout::Minimum ); //FreeResize );

  pDialog->setFilters ( qsFilter );
  pDialog->resize ( 650, 300 );

  if ( pDialog->exec () == QDialog::Accepted )
    listOfFile = pDialog->selectedFiles ();
  
  delete pPreview;
  delete pDialog;

  qt_resolve_symlinks = save_qt_resolve_symlinks;

  return listOfFile;
}

QStringList FilePreviewDialog::getOpenFileNames ( const QString &qsStartIn, const QString &qsFilter, QWidget *pParent, const char *pName, const QString &qsCaption, QString *pSelectedFilter, bool bResolveSymlinks )
{
  //////////////////////////////////////////////////////////////////////
  // This function mimics the QFileDialog::getOpenFileName function.  //
  // I implemented here again for two main reasons.                   // 
  // 1) I can create a preview for Video streams / Image files        //
  // 2) In SuSE 10.x the getOpenFile function was acting weired       //
  //    and using KDEs FileOpen Dialog with the max Screen extension. //
  //////////////////////////////////////////////////////////////////////
  QStringList listOfFile;

  QFileDialog *pDialog = new QFileDialog ( qsStartIn, QString::null, pParent, pName, false );// true );

  bool save_qt_resolve_symlinks = qt_resolve_symlinks;
  qt_resolve_symlinks = bResolveSymlinks;

  if ( pSelectedFilter )
    pDialog->setFilter               ( *pSelectedFilter );

  pDialog->setMode                   ( QFileDialog::ExistingFiles );
  pDialog->setCaption                ( qsCaption );

  pDialog->layout ()->setResizeMode  ( QLayout::Minimum ); //FreeResize );

  pDialog->setFilters ( qsFilter );
  pDialog->resize ( 650, 300 );

  if ( pDialog->exec () == QDialog::Accepted )
    listOfFile = pDialog->selectedFiles ();
  
  delete pDialog;

  qt_resolve_symlinks = save_qt_resolve_symlinks;

  return listOfFile;
}

QString FilePreviewDialog::getOpenFileName ( void *pExistingEngine, const QString &qsStartIn, const QString &qsFilter, QWidget *pParent, const char *pName, const QString &qsCaption, QString *pSelectedFilter, bool bResolveSymlinks )
{
  //////////////////////////////////////////////////////////////////////
  // This function mimics the QFileDialog::getOpenFileName function.  //
  // I implemented here again for two main reasons.                   // 
  // 1) I can create a preview for Video streams / Image files        //
  // 2) In SuSE 10.x the getOpenFile function was acting weired       //
  //    and using KDEs FileOpen Dialog with the max Screen extension. //
  //////////////////////////////////////////////////////////////////////
  QString qsFile;

  FilePreviewDialog *pPreview = new FilePreviewDialog ( pExistingEngine );
  QFileDialog *pDialog = new QFileDialog ( qsStartIn, QString::null, pParent, pName, false );// true );

  bool save_qt_resolve_symlinks = qt_resolve_symlinks;
  qt_resolve_symlinks = bResolveSymlinks;

  if ( pSelectedFilter )
    pDialog->setFilter               ( *pSelectedFilter );

  pDialog->setMode                   ( QFileDialog::ExistingFile );
  pDialog->setContentsPreviewEnabled ( true );
  pDialog->setContentsPreview        ( pPreview, pPreview );
  pDialog->setPreviewMode            ( QFileDialog::Contents );
  pDialog->setCaption                ( qsCaption );

  pDialog->layout ()->setResizeMode( QLayout::Minimum ); //FreeResize );

  pDialog->setFilters ( qsFilter );
  //  pDialog->setMinimumWidth ( 650 );
  pDialog->resize ( 650, 300 );

  if ( pDialog->exec () == QDialog::Accepted )
    qsFile = pDialog->selectedFile ();
  
  delete pPreview;
  delete pDialog;

  qt_resolve_symlinks = save_qt_resolve_symlinks;

  return qsFile;
}
