/****************************************************************************
** UndoBuffer and UndoObject classes
**   Created : Saturday Nov 30'st 2004
**        by : Varol Okan
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
****************************************************************************/
#ifndef DVDMENUUNDOOBJECT_H
#define DVDMENUUNDOOBJECT_H

#include "undobuffer.h"
#include "dvdmenu.h"

class MenuObject;
class QPixmap;

class CDVDMenuInterface;
class SourceFileEntry;
// This class will encapsulate the Undo / redo Objects for the ConstructionArea - class
// Any UndoObject will hold only the most neccesary information for undo/redo functionality 
// to work, thus no complete FunctionPainter objects or other objects will be stored herein.
///////////////////////////////////////////////////////////////////////////////////////////

class DVDMenuUndoObject : public UndoObject
{
	class BackgroundInfo	{
	public:
		BackgroundInfo ( );
		void getBackgroundInfo (CDVDMenuInterface  *);
		void setBackgroundInfo (CDVDMenuInterface  *);
		BackgroundInfo &operator = (BackgroundInfo &);

		QPixmap background;
		bool bModified;

		// the following entries belong to the movie background
		QString qsMovieFileName;
		bool    bMovieBackgroundHasSound;
		QTime   timeOffset;
		QTime   timeDuration;
		// The following var is the background image or screenshot of themovie ...
		QString qsBackgroundFileName;

		QString qsResizeAlgo;
		int iStretchType;	// StretchToFit, BlackBorders, CutOffset
		QSize posOffset;
		int iFormat;
		int iWidth;
		int iHeight;
	};

public:
	enum enUndoType {UNDEFINED = 0, DRAGGED_TEXT, DRAGGED_IMAGE,  DRAGGED_MOVIE, DRAGGED_BUTTON, MOVED_OBJECT, NEW_BACKGROUND, NEW_AUDIO};

	DVDMenuUndoObject(enUndoType, MenuObject *);
	DVDMenuUndoObject(enUndoType, QPixmap &, CDVDMenuInterface *);
	DVDMenuUndoObject(enUndoType, SourceFileEntry *);
	virtual ~DVDMenuUndoObject();

	virtual void undo (DVDMenu *);
	virtual void redo (DVDMenu *);

	virtual QString getTypeString ();
	MenuObject *getMenuObject     ();
	void        deleteMenuObject  ();
	bool        hasMoved          ();

private:
	 DVDMenuUndoObject();
	void initMe ();

private:
	// Private member variables ...
	MenuObject      *m_pMenuObject;
	bool             m_bDeleteObject;
	QRect            m_rectPos;
	BackgroundInfo   m_backgroundInfo;
	SourceFileEntry *m_pSourceFileEntry;
};

#endif // DVDMENUUNDOOBJECT_H


