/****************************************************************************
** Interface to the GUI.
**
**   Created : Sun Dec 14 12:09:08 2003
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class generates the command line for dvdauthor.
** Current Version of DVDAUTHOR used is 0.67
** You can find dvdauthor under http://dvdauthor.sourceforge.net/
**
****************************************************************************/

#ifndef BUTTONPREVIEW_H
#define BUTTONPREVIEW_H

#include <qlabel.h>
#include <qptrlist.h>
#include <qpixmap.h>

#include "menuobject.h"

class QDomNode;
class QDomElement;

class UndoBuffer;
class CDVDMenuInterface;

class ButtonPreview : public QLabel
{
	Q_OBJECT

public:
  // m_iPointerShape
  enum enPointerShape {                     MousePointerCursor=Qt::ArrowCursor, 
    MouseCrossCursor  =Qt::CrossCursor,     MouseMoveCursor   =Qt::SizeAllCursor, 
    MouseXResizeCursor=Qt::SizeHorCursor,   MouseYResizeCursor=Qt::SizeVerCursor, 
    MouseZoomCursor   =Qt::SizeFDiagCursor, MouseRotateCursor =Qt::PointingHandCursor,
    MouseLZoomCursor  =Qt::SizeFDiagCursor, MouseRZoomCursor  =Qt::SizeBDiagCursor,
  };

   ButtonPreview (QWidget * parent, const char * name = 0, WFlags f = 0 );
  ~ButtonPreview ();

  ButtonPreview & operator =    ( ButtonPreview & );
  void         toTop            ( MenuObject * );
  void         setViewport      ( QRect & );
  UndoBuffer  *undoBuffer       ( );
  MenuObject  *childContains    ( QPoint & );
  MenuObject  *menuObject       ( uint );
  uint         objectCount      ( );
  void         updatePixmap     ( );
  bool         removeObject     ( MenuObject * );
  void         addMenuObject    ( MenuObject * );
  uint         clearObjectList  ( );
  QPixmap     &renderMenu       ( CDVDMenuInterface *, long, long );
  void fitDVDMenuBackground     ( QPixmap  *, int, int, QSize, int, int );
  void         setMouseCursor   ( enPointerShape );

  virtual void drawBackground   ( QPixmap & );
  virtual void setBackground    ( QPixmap & );
  
public slots:
  virtual void slotDeleteObject ( MenuObject * );
  virtual void setPixmap        ( const QPixmap & );
  virtual void slotMoveOnStack  ( MenuObject *, int );
  virtual void slotAnimateObject( QString &, int, QString );
	
signals:
  void signalRenderProgress     ( float );
  void signalAnimateObject      ( QString &, int, QString );

protected:
  virtual void mousePressEvent	     ( QMouseEvent * );
  virtual void mouseReleaseEvent     ( QMouseEvent * );
  virtual void mouseDoubleClickEvent ( QMouseEvent * );
  virtual void setObjectCursor       ( MenuObject::enState );
  virtual void drawContents          ( QPainter * );

private:
  void drawVisibleRegion             ( QPainter * );

protected:
  // Here we have the undo buffer ...
  UndoBuffer *m_pUndoBuffer;

  QPtrList<MenuObject>	 m_listMenuObjects;
  QRect       m_rectViewport;		// This is the viewport set in drawContents()
  QPixmap     m_backgroundPixmap;
  MenuObject *m_pActiveObject;
  // tells the process to skip further handling of the MouseEvents since they were already taken care of.
  bool        m_bMouseEventDone;
  bool        m_bDrawVisibleRegion;
  int         m_iCursorStyle;
};

// I NEVER rely on my own memory, as I have determined that is not only faulty, but actively working against me.
// ROFL @ http://www.sysadminco.com/

#endif // BUTTONPREVIEW_H
