#!/usr/bin/tclsh
####################################################
# IWantVCD - A VCD transcoder tcl script.
# Copyright (C) 2003 Roi Dayan
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
####################################################
set version "0.06d"
####################################################
puts "IWantVCD v$version by Roi Dayan (roi_d@gamebox.net)"

set tc_args ""
set mpeg_args ""
set mplex_args ""

proc add {var arg {arg2 0}} {
 global $var
 if {$arg2 == 1} {
  append $var $arg
 } else {
  append $var \ $arg
 }
}

if {[lindex $argv 0] == ""} {
 puts stderr "\nUsage: ./IWantVCD.tcl <Config File>\n"
 exit
}
source [lindex $argv 0]
if {![file exists $InputFile]} {
 puts stderr "\nError: $InputFile does not exists.\n"
 exit
}

#$mv = vcd = m1v / svcd = m2v
set mt_mplex {mplex -o $OutputName%d.mpg $OutputName.$mv $OutputName.mpa}

add tc_args "-E $AudioSampleRate"
add tc_args "-b $AudioBitRate"

puts "\nChecking movie information...\n"
set tmp [catch {exec tcprobe -i $InputFile} probe]
set FPS "[lindex $probe 2]"
set WIDTH [lindex [split [lindex $probe 6] =,] 1]
set HEIGHT [lindex [split [lindex $probe 7] =] 1]
set SAMPLERATE "[lindex $probe 10]"
set BITRATE "[lindex [split [lindex $probe 15] =] 1]"

#if {($FPS == "29.97") || ($FPS == "30") || ($FPS == "23.976")} {set TYPE NTSC} else {set TYPE PAL}
if {($FPS == "29.970") || ($FPS == "23.976")} {
 set TYPE NTSC
 if {$FPS == "23.976"} {set TYPE2 film} elseif {$FPS == "29.970"} {set TYPE2 video}
} elseif {$FPS == 25.000} {
 set TYPE PAL
 set TYPE2 ""
} else {
 set TYPE2 Unknown
}
if {[info exists TYPE]} {set TYPE2 "$TYPE $TYPE2"}
puts "$probe\n
*** Input File Info ***
Size: ${WIDTH}x${HEIGHT}
FPS: $FPS ($TYPE2)
SampleRate: $SAMPLERATE
BitRate: $BITRATE kpbs
***********************\n"

if {$TYPE == "Unknown"} {
 puts "Warning! The movie has is not known as PAL or NTSC."
}

if {$SAMPLERATE != $AudioSampleRate} {
 puts "Warning! The movie samplerate is $SAMPLERATE Hz and you chose $AudioSampleRate Hz."
}

puts "******\n\nPress ENTER to continue.\n"
gets stdin

if {$TYPE == "NTSC"} {
 #NTSC
 if {$iwant == "vcd"} {
  set WIDTH_OUT 352
  set HEIGHT_OUT 240
  set exportprof "vcd-ntsc"
 } elseif {$iwant == "svcd"} {
  if {$FPS == "23.976"} {add tc_args "--pulldown"}
  set WIDTH_OUT 480
  set HEIGHT_OUT 480
  set exportprof "svcd-ntsc"
 }
} else {
 #PAL
 if {$iwant == "vcd"} {
  set WIDTH_OUT 352
  set HEIGHT_OUT 288
  set exportprof "vcd-pal"
 } elseif {$iwant == "svcd"} {
  set WIDTH_OUT 480
  set HEIGHT_OUT 576
  set exportprof "svcd-pal"
 }
}

set mpeg_args [string trim $mpeg_args \ ]
if {$mpeg_args != ""} {set mpeg_args ",\"$mpeg_args\""}

add tc_args "-y mpeg2enc,mp2enc"

if {$iwant == "vcd"} {
 set vcdimg "vcd2"
 set mv "m1v"
 add tc_args "-F 1$mpeg_args"
 add mplex_args "-f 1"
} elseif {$iwant == "svcd"} {
 set vcdimg "svcd"
 set mv "m2v"
 if {$tc_increase_bitrate} {
  add tc_args "-F 5"
  add mpeg_args "-b 4000"
  add mplex_args "-f 5"
 } else {
  add tc_args "-F 4"
  add mplex_args "-f 4"
 }
 add tc_args $mpeg_args 1
# add tc_args ",\"-V 230$argtmp\"" 1
}

set mplex_cmd [subst $mt_mplex]

#Not using do clipping.
#set DoClipping 0
if {$UseExportProf} {
 set AspectRatio -1
 set AR "Using ExportProf"
 set DoClipping 0
}

#Calculate Clipping Borders
if {$DoClipping} {
 #The next auto size check part taken from http://dvdripping-guid.berlios.de/
 ########################################
 set tmp11 [expr $HEIGHT_OUT.0 * 4/3]
#puts $tmp11
 set HOUT [expr $HEIGHT / ($WIDTH / $tmp11)]
#puts $HOUT
 set HOUT [lindex [split $HOUT .] 0]
#puts $HOUT
 set HOUT [expr $HOUT+($HOUT-($HOUT/2)*2)]
 set BORDER [expr ($HEIGHT_OUT-$HOUT)/2]
 ########################################
 set HOUT [lindex [split $HOUT .] 0]
 set BORDER [lindex [split $BORDER .] 0]
 puts "Borders: $HOUT, $BORDER"
 add tc_args "-Z ${WIDTH_OUT}x${HOUT} -Y -$BORDER,0,-$BORDER,0"
 set AspectRatio -1
 add tc_args "--export_asr 2"
 set AR "4:3 With Clipping"
} else {
 if {$UseExportProf} {
  add tc_args "--export_prof $exportprof"
 } else {
  add tc_args "-Z ${WIDTH_OUT}x${HEIGHT_OUT}"
  if {$KeepAspect} {add tc_args "--keep_asr"}
 }
}

switch -- $AspectRatio {
 0 {set AR "Not using export_asr"}
 1 {set AR 1:1}
 2 {set AR "4:3 Full Screen"}
 3 {set AR "16:9 Wide Screen"}
 4 {set AR 2.21:1}
}
if {$AspectRatio > 0} {add tc_args "--export_asr $AspectRatio"}

puts "\n******\nOutput info for $iwant
Video: ${WIDTH_OUT}x${HEIGHT_OUT} (Aspect Ratio: $AR)
Audio: ${AudioSampleRate} Hz / BitRate: ${AudioBitRate} kbps"

puts "******\n\nPress ENTER to continue.\n"
gets stdin

set tc_args [string trim $tc_args \ ]
set mplex_args [string trim $mplex_args \ ]

#mplex $mplex_args -o $OutputName.mpg $OutputName.m1v $OutputName.mpa

puts "\n******
Make your vcd with the next commands:\n
transcode -i $InputFile $tc_args -o $OutputName
$mplex_cmd $mplex_args
\n******\n
VCD Imager command for creating BIN/CUE:\n
vcdimager -t $vcdimg -c $OutputName.cue -b $OutputName.bin $OutputName.mpg
******"

