/****************************************************************************
** Interface to the GUI.
**
** Created: Tue 04 May 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class will create a toolbar, which displays all currently selected
** sources for the DVD, such as all Videos, and all Audio files.
**
** Besides displaying these it will also do some background checks.
** For this it will spawn a new thread, which will analyse the file
** and see if it needs to get converted for a propper usage.
**
** tcscan is your friend.
** 
** The result will be color coded.
** o	Gray, not yet determined
** o	any shades of green -> In DVD format.
** o	any shades of blue  -> will be converted before creating DVD
** o	any shades of red   -> Can not automatically handle this format.
**
****************************************************************************/

#ifndef SOURCETOOLBAR_H
#define SOURCETOOLBAR_H

#include <qtoolbar.h>

// The following two defines specify which column the file name is to be found. 
#define MOVIE_FILE_NAME_INDEX 7
#define AUDIO_FILE_NAME_INDEX 7

#include <qmutex.h>
#include <qthread.h>

#include "uisourcewidget.h"
#include "sourcefileentry.h"

class QDVDAuthor;
class MediaInfo;
class CSlideDialog;

class SourceToolBar : public QToolBar
{
	Q_OBJECT

public:
	 SourceToolBar     ( const QString &, QMainWindow *, QWidget *, bool b=FALSE, const char *n=0, WFlags f=0 );
	~SourceToolBar     ( );
 
	void addMovie      (SourceFileEntry * );
	void addMovieList  ( QStringList &, QString *p=NULL );
	void addSound      ( QStringList & );
	void clear         ( );
	
	int sourceFileCount                        ( );
	int  getFreeSourceSlot                     ( );
	SourceFileEntry *sourceFileEntry           ( uint );
	SourceFileEntry *getCurrentSourceFileEntry ( );
	SourceFileInfo  *getCurrentSourceFileInfo  ( );
	bool checkRightFileFormat                  ( SourceFileInfo * );
	void appendSourceFileEntry                 ( SourceFileEntry * );
	void removeEntry                           ( QString &, bool b=true );
	void removeEntry                           ( SourceFileEntry *, bool b=true );

	virtual QSize sizeHint                     ( ) const;
	QString convertFileSize                    ( uint );

	MediaInfo *getMediaInfo                    ( );

protected:
	virtual void  timerEvent      ( QTimerEvent * );

private:
	void  refreshToolBarEntries   ( );
	void *getMediaEngine          ( );
	void  importChapters          ( QString, SourceFileInfo * );
	void  updateEntryHeader       ( SourceFileEntry * );
	void  updateListViewItem      ( SourceFileInfo  * );

public slots:
	virtual void slotDoubleClickedOnVideoList( QListViewItem *, const QPoint &, int );
	virtual void slotRightClickedOnVideoList ( QListViewItem *, const QPoint &, int );
	virtual void slotClickedOnVideoList      ( QListViewItem *, const QPoint &, int );
	virtual void slotPlayMovie    ( );
	virtual void slotEditMovie    ( );
	virtual void slotDeleteSource ( );
	virtual void slotTranscodeAll ( );

	virtual void slotAddMovie     ( );
	virtual void slotAddSound     ( );
	virtual void slotAddSlideshow ( );
	virtual void slotSetThumbnail ( long );
	virtual void slotAddSlideshow ( QString );
	virtual void slotSlideshowDone( QString, QString );
	virtual void slotRemoveEntry  ( SourceFileEntry * );

private:
	uiSourceWidget    *m_pSourceWidget;
	QMutex             m_mutexThumbnails;
	MediaInfo         *m_pMediaInfo;
	CSlideDialog      *m_pSlideDialog;
	QDVDAuthor        *m_pDVDAuthor;
	QListView         *m_pListViewAllSources;
	QValueList<SourceFileEntry *>	m_listSourceFileEntries;
};

#endif // SOURCETOOLBAR_H


