/****************************************************************************
** SourceFileEntry - class
**
** Created: Tue Mar 22 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class is a simple container class to store the info
** for a entry in the Source File List.
**
****************************************************************************/

#ifndef SOURCEFILEENTRY_H
#define SOURCEFILEENTRY_H

#include <qstringlist.h>
#include <qfont.h>
#include <qsize.h>

class QDomNode;
class QDomElement;
class QImage;

#define MAX_COLORS 4

class Subtitles
{
public:
  class entry {
  public:
    entry ();
    entry &operator = ( entry & );

    int iIndex;
    QString qsTimeStart;// 00:00:00.000
    QString qsTimeStop; // 00:00:00.000
    long    iTimeStart; // in ms
    long    iTimeStop;  // in ms
    QString qsText;
    QRect   rect;       // Note not stored as it is created when drawing the text.
  };

   Subtitles ();
  ~Subtitles ();

  Subtitles & operator =    ( Subtitles   & );
  bool    readProjectFile   ( QDomNode    & );
  bool    writeProjectFile  ( QDomElement & );
  long    getTimeFromString ( QString     & );
  QString getStringFromTime ( long          );
  QString getXMLFileName    (               );
    
  QFont                font;
  QRect                rect;
  QPoint               alignment;
  QValueList <entry *> listOfSubtitles;
  // this is the file that is going to be created.
  QString              qsTempFile; 
  QColor               subColors[ MAX_COLORS ];
  unsigned char        iTransparency; // 0 .. 255
};

class TranscodeInterface
{
public:
	 TranscodeInterface ();
	~TranscodeInterface ();
	TranscodeInterface & operator = (TranscodeInterface &);
	bool operator == (const TranscodeInterface &);
	bool operator != (const TranscodeInterface &);
	bool readProjectFile  (QDomNode &);
	bool writeProjectFile (QDomElement &);

	QString qsVideoFormat;
	QString qsVideoType;
	QString qsResolution;
	int     iVideoBitrate;
	float   fFrameRate;
	QString qsRatio;

	QString qsAudioFormat;
	QString qsAudioType;
	int     iAudioBitrate;
	int     iSample;

	int     iStartingAt;	// The movie should start here (in mSec)
	int     iEndingAt;	// The movie should stop here
	bool    bRemuxOnly;     // If we have the right sized video stream in Mpeg2 format we only need to remux instead of a complete transcoding process.
	bool    bTranscoding;	// This flag indicates that the transcoding process is currently ongoing.
	// Note: once the transcoding part terminates, 
	// o the transcoding interface is deleted, 
	// o the original file-name is replaced with the generated mpeg2 movie file-name
	QString     qsTempFile;
};

// the following class is filled with information after the source has been added to the SourceToolbar
class SourceFileInfo
{
public:
	 SourceFileInfo ();
	~SourceFileInfo ();

	SourceFileInfo & operator = (SourceFileInfo &);
	QString getFileName ();

	QString qsFileName;	  // E.g. video.mpg
	QString qsSize;		  // E.g. 2.2M
	QString qsResolution;	  // E.g. 720x576
	QString qsFPS;		  // E.g. 25
	QString qsRatio;	  // E.g. 16:9
	QString qsLength;	  // E.g. 01:22:23
	QString qsVideoFormat;	  // E.g. for video :'PAL' // used to be also for audio 
	QString qsStatus;	  // E.g. Ok	-=> to say this file we can autmatically convert to a DVD video
	// For Audio Sources :
	QString qsAudioFormat;    // E.g. 'Stereo' 
	QString qsBits;		  // E.g. 16
	QString qsSample;	  // E.g. 48kHz
	QString qsBPS;		  // E.g. 00:05:32

	long    iMSecPreview;     // The preview is to be generated iMSec from the start.
	QImage *pPreview;	  // Image of the size for the Button
	bool    bUpdateInfo;	  // if the preview has been generated we set this flag to indicate this.
	                   
	QStringList listChapters; // The chapters of this SourceFile entry
	QString     qsPreCommand; // The Pre  Command tag for dvdauthor
	QString     qsPostCommand;// The Post command tag for dvdauthor
	int         iPause;       // The pause attribute for dvdauthor (-1=inf)
	int         iTitleset;    // In case the user wants to define the titleset number
	bool        bAutotranscode; // The user elected not to have this entry autotranscoded any more.
	TranscodeInterface *pTranscodeInterface;
	Subtitles   *pSubtitles;
};

// Note if the entry is a dvd-slideshow, then the qsDisplayName will end in .xml
// Once the slideshow has been generated, the name is changed to .mpg
class SourceFileEntry
{
public:
	 SourceFileEntry ();
	~SourceFileEntry ();

	bool readProjectFile  (QDomNode &);
	bool writeProjectFile (QDomElement &, bool b=false);
	SourceFileEntry & operator = (SourceFileEntry &);
	SourceFileEntry * flatClone  ( );

	QString qsDisplayName;          // The name that appears on the display
	QValueList <SourceFileInfo *> listFileInfos;
	QStringList listChapters;       // The chapters of this SourceFile entry
	bool bIsSlideshow;              // Will be re-set, once the slideshow has been created into a mpeg2 movie.
	bool bSoundSource;              // Indicates if this is a movie or a Sound source

	int iTitleset;                  // Set when processing createDvdauthorXml () function
	int iTitle;                     // Set when processing createDvdauthorXml () function
	int iJumpStart;                 // Set when processing createDvdauthorXml () function
	QSize sizeThumbnail;            // The size of the thumbnail
	QString qsPre;
	QString qsPost;
	int     iPause;                 // The pause attribute for dvdauthor (-1=inf)
};

#endif // SOURCEFILEENTRY_H

