/****************************************************************************
** ListViewMedia class to
**
** Created: Sat Nov 27 12:09:08 2004
**      by: Varol Okan using kate editor
**
****************************************************************************/

#ifndef LISTVIEWMEDIA_H
#define LISTVIEWMEDIA_H

#include <qlistview.h>

class SourceFileInfo;
class SourceFileEntry;

class ListViewMedia : public QListView
{
	Q_OBJECT
public:
	ListViewMedia (QWidget *p=0, const char *n=0, WFlags f=0);
	virtual ~ListViewMedia ();

	// Overloaded function
	virtual QDragObject *dragObject  ();
	virtual void dropEvent (QDropEvent *);
	virtual void dragEnterEvent(QDragEnterEvent *);

	void             resetDragging ();
	SourceFileEntry *draggingSourceFileEntry();
	SourceFileInfo  *draggingSourceFileInfo ();

public slots:
	void slotItemClicked (QListViewItem *, const QPoint &, int);

signals:
	void signalRemoveEntry (SourceFileEntry *);

private:
	SourceFileEntry *m_pDraggingSourceFileEntry;
	SourceFileInfo  *m_pDraggingSourceFileInfo;
};

#endif // LISTVIEWMEDIA_H
