/****************************************************************************
** listboxcolortext.h file.
**
** This file re-implements the QListBoxText class
** and adds only a background color to it.
**
** For later this could be enhanced to include a small Icon at the beginning
** Which indicates the type (I.e. single movie, movie collection, or dvd-slideshow).
**
** Another icon on the right side could indicate if a movie is already
** connected to a button or action.
**
** And yet another Icon could indicate the (intended) Format of the Movie.
**
*****************************************************************************/
#include <qlistbox.h>
#include <qpainter.h>

#include "listboxcolortext.h"




ListBoxColorText::ListBoxColorText (const QString &string, const QColor &color)
	: QListBoxText (string)
{
	m_backgroundColor = color;
}

ListBoxColorText::~ListBoxColorText ()
{
}

int ListBoxColorText::width (const QListBox *pListBox)
{
	return pListBox->width();
}

void ListBoxColorText::paint (QPainter *p)
{
	int itemHeight = height( listBox() );
	int itemWidth  = width ( listBox() );

	QBrush theBrush (m_backgroundColor);
	p->setBrush (theBrush);
	p->drawRect(0, 0, itemWidth, itemHeight);
	p->setBackgroundColor (m_backgroundColor);
	QListBoxText::paint(p);
}

