/****************************************************************************
** DialogShadow
**
** Created: Sat Aug 3 22:05:28 2006
**      by: Varol Okan using XEmacs
**
****************************************************************************/

#include <qdial.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qtimer.h>
#include <qslider.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qlineedit.h>
#include <qscrollview.h>
#include <qpushbutton.h>
#include <qcolordialog.h>


#include "global.h" // for PI
#include "shadowobject.h"
#include "menuobject.h"
#include "dialogshadow.h"

// Init static member variables
int    DialogShadow::m_keepBlurRadius    =    0;
float  DialogShadow::m_keepTransparency  =  0.0;
float  DialogShadow::m_keepDistance      = 10.0;
float  DialogShadow::m_keepSunAngle      = 33.0f;
QColor DialogShadow::m_keepColor         = QColor ( 0, 0, 0 );

DialogShadow::DialogShadow ( QWidget* parent, const char* name, bool modal, WFlags fl )
    : uiDialogShadow ( parent, name, modal, fl )
{
  m_pBackground  = NULL;
  m_pShadow      = NULL;
  m_pOrigShadow  = NULL;
  m_pMenuObject  = NULL;
  m_pPreview     = NULL;
  m_pScrollView  = NULL;

  m_pDialSunAngle->setMinValue       (     0 );
  m_pDialSunAngle->setMaxValue       ( 36000 );
  m_pSliderBlur->setMinValue         (     2 );
  m_pSliderBlur->setMaxValue         (    50 );
  m_pSliderDistance->setMinValue     (     0 );
  m_pSliderDistance->setMaxValue     (   100 );
  m_pSliderTransparency->setMinValue (     0 );
  m_pSliderTransparency->setMaxValue ( 10000 );
  m_pDialSunAngle->setValue          ( 31500 );

  m_pSliderBlur->setTickmarks            ( QSlider::Below );
  m_pSliderDistance->setTickmarks        ( QSlider::Below );
  m_pSliderTransparency->setTickmarks    ( QSlider::Right );
  m_pSliderTransparency->setLineStep     (  100 );
  m_pSliderTransparency->setPageStep     ( 1000 );
  m_pSliderTransparency->setTickInterval ( 1000 );

  QGridLayout *pLayout;
  uint iFlags = 0;

#if (QT_VERSION > 0x0301FF)
	iFlags = Qt::WNoAutoErase;
#else
	iFlags = Qt::WPaintClever;
#endif

  pLayout       = new QGridLayout ( m_pLabelPreview, 1, 1, 2, 2, "pFramePreviewLayout");
  m_pScrollView = new QScrollView ( m_pLabelPreview, "m_pScrollView", iFlags );
  m_pPreview    = new QLabel      ( m_pScrollView,   "pPreview",    iFlags );
  m_pScrollView->addChild ( m_pPreview );
  m_pPreview->resize      (  720, 480  );
  pLayout->addWidget      ( m_pScrollView, 0, 0 );

  m_pEditDistance->setText   ( "25" );
  m_pSliderDistance->setValue ( 25 );
  m_pLabelColor->setPaletteBackgroundColor ( QColor ( 0, 0, 0 ) );
}

DialogShadow::~DialogShadow ( )
{
  if ( m_pShadow )
    delete m_pShadow;
  if ( m_pOrigShadow )
    delete m_pOrigShadow;
  m_pShadow     = NULL;
  m_pOrigShadow = NULL;
}

void DialogShadow::initMe ( MenuObject *pMenuObject, QPixmap *pBackground )
{
  m_pBackground =  pBackground;
  if ( pMenuObject ) {
     m_pMenuObject = pMenuObject;
     m_pShadow = new ShadowObject ( m_pMenuObject );
     if ( pMenuObject->shadow ( ) ) {
       ShadowObject    *pCurrentShadow = ( ShadowObject *) pMenuObject->shadow ( );
       m_pOrigShadow =  new ShadowObject ( m_pMenuObject );
      *m_pOrigShadow = *pCurrentShadow;
      *m_pShadow     = *pCurrentShadow;
     }
     else
       setStaticVariables ( );
     int iBlur         =        m_pShadow->blur         ( );
     int iDelta        =      ( m_pShadow->sunAngle     ( ) <    90.0 ) ? 27000 : -9000;
     int iSunAngle     = (int)( m_pShadow->sunAngle     ( ) *   100.0 ) + iDelta;
     int iTransparency = (int)( m_pShadow->transparency ( ) * 10000.0 );
     m_pMenuObject->setShadow        ( NULL );
     m_pEditDistance->setText        ( QString ( "%1" ).arg ( (int) m_pShadow->distance ( ) ) );
     m_pSliderDistance->setValue     ( (int)m_pShadow->distance ( ) );
     m_pSliderTransparency->setValue ( iTransparency );
     m_pDialSunAngle->setValue       (   iSunAngle   );
     m_pSliderBlur->setValue         (     iBlur     );
     m_pLabelColor->setPaletteBackgroundColor ( m_pShadow->color ( ) );
   
     { // this hack is to prevent three times refresh if not needed.
       ShadowObject *pTemp = m_pShadow;
       m_pShadow = NULL;
       slotBlur         (     iBlur     );
       slotSunAngle     (   iSunAngle   );
       slotTransparency ( iTransparency );
       m_pShadow = pTemp;
     }
  }
  refresh ( );

  connect ( m_pButtonOkay,         SIGNAL ( clicked ( ) ), this, SLOT ( accept ( ) ) );
  connect ( m_pButtonCancel,       SIGNAL ( clicked ( ) ), this, SLOT ( reject ( ) ) );
  connect ( m_pButtonColor,        SIGNAL ( clicked ( ) ), this, SLOT ( slotShadowColor ( ) ) );

  connect ( m_pSliderDistance,     SIGNAL ( valueChanged ( int ) ), this, SLOT ( slotDistance     ( int ) ) );
  connect ( m_pSliderTransparency, SIGNAL ( valueChanged ( int ) ), this, SLOT ( slotTransparency ( int ) ) );
  connect ( m_pDialSunAngle,       SIGNAL ( valueChanged ( int ) ), this, SLOT ( slotSunAngle     ( int ) ) );
  connect ( m_pSliderBlur,         SIGNAL ( valueChanged ( int ) ), this, SLOT ( slotBlur         ( int ) ) );

  QTimer::singleShot ( 0, this, SLOT (slotCenterScrollView ( ) ) );
}

void DialogShadow::accept ( )
{
  keepStaticVariables ( );
  m_pMenuObject->setShadow ( m_pShadow );
  m_pShadow = NULL;
  
  QDialog::accept ( );
}

void DialogShadow::reject ( )
{
  if ( m_pOrigShadow )
    m_pMenuObject->setShadow ( m_pOrigShadow );
  m_pOrigShadow = NULL;
  
  QDialog::reject ( );
}

void DialogShadow::keepStaticVariables ( )
{
  if ( ! m_pShadow )
    return;

  m_keepBlurRadius   = m_pShadow->blur         ( );
  m_keepTransparency = m_pShadow->transparency ( );
  m_keepDistance     = m_pShadow->distance     ( );
  m_keepSunAngle     = m_pShadow->sunAngle     ( );
  m_keepColor        = m_pShadow->color        ( );
}

void DialogShadow::setStaticVariables ( )
{
  if ( ! m_pShadow )
    return;
  
  m_pShadow->setBlur         ( m_keepBlurRadius   );
  m_pShadow->setTransparency ( m_keepTransparency );
  m_pShadow->setDistance     ( m_keepDistance     );
  m_pShadow->setSunAngle     ( m_keepSunAngle     );
  m_pShadow->setColor        ( m_keepColor        );
}

void DialogShadow::slotCenterScrollView ( )
{
  drawShadow ( );

  int iScrollToX, iScrollToY;
  iScrollToX = m_pMenuObject->rect ( ).x ( ) - 15;
  if ( iScrollToX < 1 )
       iScrollToX = 1;
  iScrollToY = m_pMenuObject->rect ( ).y ( ) - 15;
  if ( iScrollToY < 1 )
       iScrollToY = 1;
  m_pScrollView->setContentsPos ( iScrollToX, iScrollToY );
}

void DialogShadow::slotShadowColor ( )
{
  QColor newColor = QColorDialog::getColor ( m_pShadow->color ( ), this );
  m_pLabelColor->setPaletteBackgroundColor ( newColor );
  refresh ( );
}

// called from m_pSliderTransparency
void DialogShadow::slotTransparency ( int iTransparency ) // [ 0 .. 10000 ]
{
  QString qsText;
  float   fValue = iTransparency / 100.0;

  qsText.sprintf ( "<B><CENTER>%0.2f%%</CENTER></B>", fValue );
  m_pLabelTransparency->setText ( qsText );

  refresh ( );
}

// called from m_pSliderDistance
void DialogShadow::slotDistance ( int iDistance ) // [ 0 .. 100 ]
{
  QString qsText;

  qsText.sprintf  ( "%d",  ( iDistance < 3 ) ? 0 : iDistance );
  m_pEditDistance->setText ( qsText );

  refresh ( );
}

// called from m_pSliderBlur
void DialogShadow::slotBlur ( int iBlur ) // [ 0 .. 50 ]
{
  QString qsText;
  if ( iBlur < 3 )  
       iBlur = 0;
  qsText.sprintf ( tr ("<B><CENTER>Blur radius [%d]</CENTER></B>" ), iBlur );
  m_pLabelBlur->setText ( qsText );

  refresh ( );
}

// called from m_pDialSunAngle
void DialogShadow::slotSunAngle ( int iAngle )
{
  // The angle is between 0 and 360.00
  float fAngle  = (float) ( iAngle -27000 )  / 100.0;
  if  ( fAngle  <   0.0 ) 
        fAngle += 360.0;
  
  QString qsText;
  qsText.sprintf ( "<p align=\"center\"><b>SunAngle [%0.2f%%]</b></p>", fAngle );
  m_pLabelSunAngle->setText ( qsText );

  refresh ( );
}

void DialogShadow::refresh ( )
{
  if ( ( ! m_pMenuObject ) || ( ! m_pShadow ) )
    return;

  QColor backgroundColor =   m_pLabelColor->paletteBackgroundColor ( );
  float  fTransparency   =   m_pSliderTransparency->value ( ) / 10000.0;
  int    iBlurRadius     =   m_pSliderBlur->value   ( );
  float  fDistance       =   m_pEditDistance->text  ( ).toFloat ( );
  float  fSunAngle       = ( m_pDialSunAngle->value ( ) - 27000 ) / 100.0;
  if ( fSunAngle < 0.0 )
       fSunAngle += 360.0;

  m_pShadow->setTransparency ( fTransparency );
  m_pShadow->setColor        ( backgroundColor );
  m_pShadow->setBlur         ( iBlurRadius );
  m_pShadow->setDistance     ( fDistance );
  m_pShadow->setSunAngle     ( fSunAngle );

  m_pShadow->updateShadow ( );
  drawShadow ( );
}

void DialogShadow::drawShadow ( ) 
{
  QPixmap  thePixmap = *m_pBackground;
  QPainter thePainter ( &thePixmap );
  
  m_pShadow    ->drawContents ( &thePainter );
  m_pMenuObject->drawContents ( &thePainter );

  m_pPreview->setPaletteBackgroundPixmap  ( thePixmap );
  m_pPreview->resize ( thePixmap.width ( ), thePixmap.height ( ) );
}


