/****************************************************************************
** Interface to the GUI.
**
** Created: Tue 04 May 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class will create a toolbar, which displays all currently selected
** sources for the DVD, such as all Videos, and all Audio files.
**
** Besides displaying these it will also do some background checks.
** For this it will spawn a new thread, which will analyse the file
** and see if it needs to get converted for a propper usage.
**
** tcscan is your friend.
** 
** The result will be color coded.
** o	Gray, not yet determined
** o	any shades of green -> In DVD format.
** o	any shades of blue  -> will be converted before creating DVD
** o	any shades of red   -> Can not automatically handle this format.
**
****************************************************************************/

#ifndef SOURCETOOLBAR_H
#define SOURCETOOLBAR_H

#include <qtoolbar.h>

// The following two defines specify which column the file name is to be found. 
#define MOVIE_FILE_NAME_INDEX 7
#define AUDIO_FILE_NAME_INDEX 7

#include <qthread.h>

#include "uisourcewidget.h"
#include "sourcefileentry.h"

class QDVDAuthor;
class MediaInfo;

class SourceToolBar : public QToolBar
{
	Q_OBJECT

public:
	 SourceToolBar (const QString &, QMainWindow *, QWidget *, bool b=FALSE, const char *n=0, WFlags f=0);
	~SourceToolBar ();

	void addMovie     (SourceFileEntry *);
	void addMovieList (QStringList &, QString *p=NULL);
	void addSound     (QStringList &);
	void clear        ();
	
	int sourceFileCount();
	SourceFileEntry *sourceFileEntry(uint);
	SourceFileEntry *getCurrentSourceFileEntry();
	SourceFileInfo  *getCurrentSourceFileInfo ();
	void appendSourceFileEntry(SourceFileEntry *);
	void removeEntry (QString &, bool b=true);
	void removeEntry (SourceFileEntry *, bool b=true);
	int  getFreeSourceSlot       ();

	virtual QSize sizeHint () const;
	QString convertFileSize(uint);

	MediaInfo *getMediaInfo ();

protected:
	virtual void  timerEvent      (QTimerEvent *);

private:
	void  refreshToolBarEntries   ();
	void *getMediaEngine          ();
//	void  makeScreenshots         (SourceFileEntry *);

public slots:
	virtual void slotDoubleClickedOnVideoList(QListViewItem *, const QPoint &, int);
	virtual void slotRightClickedOnVideoList (QListViewItem *, const QPoint &, int);
	virtual void slotClickedOnVideoList      (QListViewItem *, const QPoint &, int);
	virtual void slotPlayMovie    ();
	virtual void slotEditMovie    ();
	virtual void slotDeleteSource ();

	virtual void slotAddMovie     ();
	virtual void slotAddSound     ();
	virtual void slotAddSlideshow ();
	virtual void slotAddSlideshow (QString);
	virtual void slotSlideshowDone(QString);
	virtual void slotRemoveEntry  (SourceFileEntry *);

private:
	uiSourceWidget    *m_pSourceWidget;
	MediaInfo         *m_pMediaInfo;
	QDVDAuthor        *m_pDVDAuthor;
	QListView         *m_pListViewAllSources;
	QValueList<SourceFileEntry *>	m_listSourceFileEntries;
};

#endif // SOURCETOOLBAR_H


