/****************************************************************************
** SourceFileEntry - class
**
** Created: Tue Mar 22 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class is a simple container class to store the info
** for a entry in the Source File List.
**
****************************************************************************/

#ifndef SOURCEFILEENTRY_H
#define SOURCEFILEENTRY_H

#include <qstringlist.h>
#include <qsize.h>

class QDomNode;
class QDomElement;
class QImage;

class TranscodeInterface
{
public:
	 TranscodeInterface ();
	~TranscodeInterface ();
	TranscodeInterface & operator = (TranscodeInterface &);
	bool readProjectFile  (QDomNode &);
	bool writeProjectFile (QDomElement &);

	QString qsVideoFormat;
	QString qsVideoType;
	QString qsResolution;
	int     iVideoBitrate;
	float   fFrameRate;
	QString qsRatio;

	QString qsAudioFormat;
	QString qsAudioType;
	int     iAudioBitrate;
	int     iSample;

	int     iStartingAt;	// The movie should start here (in mSec)
	int     iEndingAt;	// The movie should stop here
	bool    bTranscoding;	// This flag indicates that the transcoding process is currently ongoing.
	// Note: once the transcoding part terminates, 
	// o the transcoding interface is deleted, 
	// o the original file-name is replaced with the generated mpeg2 movie file-name
};

// the following class is filled with information after the source has been added to the SourceToolbar
class SourceFileInfo
{
public:
	 SourceFileInfo ();
	~SourceFileInfo ();

	SourceFileInfo & operator = (SourceFileInfo &);

	QString qsFileName;	  // E.g. video.mpg
	QString qsSize;		  // E.g. 2.2M
	QString qsResolution;	  // E.g. 720x576
	QString qsFPS;		  // E.g. 25
	QString qsRatio;	  // E.g. 16:9
	QString qsLength;	  // E.g. 01:22:23
	QString qsFormat;	  // E.g. for video :'PAL' or for audio :'Stereo' 
	QString qsStatus;	  // E.g. Ok	-=> to say this file we can autmatically convert to a DVD video
	// For Audio Sources :
	QString qsBits;		  // E.g. 16
	QString qsSample;	  // E.g. 48kHz
	QString qsBPS;		  // E.g. 00:05:32

	QImage *pPreview;	  // Image of the size for the Button
	bool    bUpdateInfo;	  // if the preview has been generated we set this flag to indicate this.

	QStringList listChapters; // The chapters of this SourceFile entry
	QString     qsPreCommand; // The Pre  Command tag for dvdauthor
	QString     qsPostCommand;// The Post command tag for dvdauthor
	int         iPause;       // The pause attribute for dvdauthor (-1=inf)
	TranscodeInterface *pTranscodeInterface;
};

// Note if the entry is a dvd-slideshow, then the qsDisplayName will end in .xml
// Once the slideshow has been generated, the name is changed to .mpg
class SourceFileEntry
{
public:
	 SourceFileEntry ();
	~SourceFileEntry ();

	bool readProjectFile  (QDomNode &);
	bool writeProjectFile (QDomElement &);
	SourceFileEntry & operator = (SourceFileEntry &);

	QString qsDisplayName;          // The name that appears on the display
	QValueList <SourceFileInfo *> listFileInfos;
	QStringList listChapters;       // The chapters of this SourceFile entry
	bool bIsSlideshow;
	bool bSoundSource;              // Indicates if this is a movie or a Sound source

	int iTitleset;                  // Set when processing createDvdauthorXml () function
	int iTitle;                     // Set when processing createDvdauthorXml () function
	QSize sizeThumbnail;            // The size of the thumbnail
};

#endif // SOURCEFILEENTRY_H

