/****************************************************************************
** SourceFileEntry - class
**
** Created: Tue Mar 22 12:09:08 2004
**      by: Varol Okan using kate editor
**
** This class is a simple container class to store the info
** for a entry in the Source File List.
**
****************************************************************************/

#include <qmessagebox.h>
#include <qfileinfo.h>
#include <qimage.h>
#include <qdom.h>
#include <qdatetime.h>

#include "xml_dvd.h"
#include "sourcefileentry.h"
	 
TranscodeInterface::TranscodeInterface ()
{
	iVideoBitrate = 0;
	fFrameRate    = 0.0f;
	iAudioBitrate = 0;
	iSample       = 0;
	iStartingAt   = 0;
	iEndingAt     = 0;
	bTranscoding  = false;
}

TranscodeInterface::~TranscodeInterface ()
{

}

TranscodeInterface & TranscodeInterface::operator = (TranscodeInterface &theOther)
{
	qsVideoFormat = theOther.qsVideoFormat;
	qsVideoType   = theOther.qsVideoType;
	qsResolution  = theOther.qsResolution;
	iVideoBitrate = theOther.iVideoBitrate;
	fFrameRate    = theOther.fFrameRate;
	qsRatio       = theOther.qsRatio;
	qsAudioFormat = theOther.qsAudioFormat;
	qsAudioType   = theOther.qsAudioType;
	iAudioBitrate = theOther.iAudioBitrate;
	iSample       = theOther.iSample;
	iStartingAt   = theOther.iStartingAt;
	iEndingAt     = theOther.iEndingAt;
	bTranscoding  = theOther.bTranscoding;
	return *this;
}

bool TranscodeInterface::readProjectFile  (QDomNode &xmlNode)
{
	QString qsAttribute;
	QDomElement theElement = xmlNode.toElement();

	qsAttribute = theElement.attributeNode ( TRANSCODE_VIDEO_FORMAT ).value();
	if (!qsAttribute.isEmpty())
		qsVideoFormat = qsAttribute;
	qsAttribute = theElement.attributeNode ( TRANSCODE_VIDEO_TYPE ).value();
	if (!qsAttribute.isEmpty())
		qsVideoType = qsAttribute;
	qsAttribute = theElement.attributeNode ( TRANSCODE_RESOLUTION ).value();
	if (!qsAttribute.isEmpty())
		qsResolution = qsAttribute;
	qsAttribute = theElement.attributeNode ( TRANSCODE_VIDEO_BITRATE ).value();
	if (!qsAttribute.isEmpty())
		iVideoBitrate = qsAttribute.toInt ();
	qsAttribute = theElement.attributeNode ( TRANSCODE_FRAME_RATE ).value();
	if (!qsAttribute.isEmpty())
		fFrameRate = qsAttribute.toFloat ();
	qsAttribute = theElement.attributeNode ( TRANSCODE_RATIO ).value();
	if (!qsAttribute.isEmpty())
		qsRatio = qsAttribute;
	qsAttribute = theElement.attributeNode ( TRANSCODE_AUDIO_FORMAT ).value();
	if (!qsAttribute.isEmpty())
		qsAudioFormat = qsAttribute;
	qsAttribute = theElement.attributeNode ( TRANSCODE_AUDIO_TYPE ).value();
	if (!qsAttribute.isEmpty())
		qsAudioType = qsAttribute;
	qsAttribute = theElement.attributeNode ( TRANSCODE_AUDIO_BITRATE ).value();
	if (!qsAttribute.isEmpty())
		iAudioBitrate = qsAttribute.toInt ();
	qsAttribute = theElement.attributeNode ( TRANSCODE_SAMPLE_RATE ).value();
	if (!qsAttribute.isEmpty())
		iSample = qsAttribute.toInt();
	qsAttribute = theElement.attributeNode ( TRANSCODE_STARTING_AT ).value();
	if (!qsAttribute.isEmpty())
		iStartingAt = qsAttribute.toInt();
	qsAttribute = theElement.attributeNode ( TRANSCODE_ENDING_AT ).value();
	if (!qsAttribute.isEmpty())
		iEndingAt = qsAttribute.toInt ();

	return true;
}

bool TranscodeInterface::writeProjectFile (QDomElement &theElement)
{
	// Here we set the attributes of the <TranscodeInterface> tag
	if (!qsVideoFormat.isNull())
		theElement.setAttribute( TRANSCODE_VIDEO_FORMAT, qsVideoFormat );
	if (!qsVideoType.isNull())
		theElement.setAttribute( TRANSCODE_VIDEO_TYPE, qsVideoType );
	if (!qsResolution.isNull())
		theElement.setAttribute( TRANSCODE_RESOLUTION, qsResolution );
	if (iVideoBitrate > 0)
		theElement.setAttribute( TRANSCODE_VIDEO_BITRATE, QString ("%1").arg(iVideoBitrate) );
	if (fFrameRate > 0.0)
		theElement.setAttribute( TRANSCODE_FRAME_RATE, QString ("%1").arg(fFrameRate) );
	if (!qsRatio.isNull())
		theElement.setAttribute( TRANSCODE_RATIO, qsRatio );
	if (!qsAudioFormat.isNull())
		theElement.setAttribute( TRANSCODE_AUDIO_FORMAT, qsAudioFormat );
	if (!qsAudioType.isNull())
		theElement.setAttribute( TRANSCODE_AUDIO_TYPE, qsAudioType );
	if (iAudioBitrate > 0)
		theElement.setAttribute( TRANSCODE_AUDIO_BITRATE, QString ("%1").arg(iAudioBitrate) );
	if (iSample > 0)
		theElement.setAttribute( TRANSCODE_SAMPLE_RATE, QString ("%1").arg(iSample) );
	if (iStartingAt > 0)
		theElement.setAttribute( TRANSCODE_STARTING_AT, QString ("%1").arg(iStartingAt) );
	if (iEndingAt > 0)
		theElement.setAttribute( TRANSCODE_ENDING_AT, QString ("%1").arg(iEndingAt) );

	return true;
}

SourceFileInfo::SourceFileInfo ()
{
	pPreview = NULL;
	pTranscodeInterface = NULL;
	bUpdateInfo = false;
	iPause = -1;
}

SourceFileInfo::~SourceFileInfo ()
{
	if (pPreview)
		delete pPreview;
	if (pTranscodeInterface)
		delete pTranscodeInterface;
}

SourceFileEntry::SourceFileEntry ()
{
	bIsSlideshow = false;
	iTitleset = 0;
	iTitle    = 0;
	bSoundSource = false;
	sizeThumbnail = QSize (150, 150);
}

SourceFileEntry::~SourceFileEntry()
{
	uint t;
	for (t=0;t<listFileInfos.count();t++)	
		delete listFileInfos[t];
}

bool SourceFileEntry::readProjectFile  (QDomNode &xmlNode)
{
	QString qsAttribute, infoName, infoText;

	QDomNode    infoNode, transcodeNode;
	QDomElement infoElement;
	QDomElement theElement = xmlNode.toElement();

	QDomAttr a = theElement.attributeNode ( SOURCE_OBJECT_DISPLAY_NAME );
	qsDisplayName = a.value();
	qsAttribute = theElement.attributeNode ( SOURCE_OBJECT_IS_SOUND_SOURCE ).value();
	bSoundSource = false;
	
	if ( (!qsAttribute.isEmpty ()) && (qsAttribute == QString ("true")) )
			bSoundSource = true;

	QDomNode sourceNode = theElement.firstChild();
	while (!sourceNode.isNull() )	{
		theElement = sourceNode.toElement();
		// Okay, here we read the stored data from the xml file.
		QString tagName = theElement.tagName();
		// Okay, this is ugly but after all it is the simplest of all xml file structure.
		// No need to get fancy ...
		if (SOURCE_OBJECT_INFO == tagName)	{
			SourceFileInfo *pFileInfos = new SourceFileInfo;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_SIZE).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsSize = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_RESOLUTION).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsResolution = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_FPS).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsFPS = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_RATIO).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsRatio = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_LENGTH).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsLength = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_FORMAT).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsFormat = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_STATUS).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsStatus = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_BITS).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsBits = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_SAMPLE).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsSample = qsAttribute;
			qsAttribute = theElement.attributeNode (SOURCE_OBJECT_BPS).value();
			if (!qsAttribute.isEmpty ())
				pFileInfos->qsBPS = qsAttribute;

			infoNode = theElement.firstChild ();
			while (!infoNode.isNull())	{
				infoElement = infoNode.toElement();
				// Okay, here we read the stored data from the xml file.
				infoName = infoElement.tagName();
				infoText = infoElement.text ();
				if (SOURCE_OBJECT_FILE_NAME == infoName)	{
					if (!infoText.isEmpty())
						pFileInfos->qsFileName = infoText;
				}
				else if (SOURCE_OBJECT_CHAPTERS == infoName)	{
					if (!infoText.isEmpty())
						pFileInfos->listChapters = QStringList::split (",", infoText);
				}
				else if (SOURCE_OBJECT_PROPERTIES == infoName)	{
					qsAttribute = infoElement.attributeNode (SOURCE_PROPERTIES_POST).value();
					if (!qsAttribute.isEmpty())
						pFileInfos->qsPostCommand = qsAttribute;
					qsAttribute = infoElement.attributeNode (SOURCE_PROPERTIES_PRE).value();
					if (!qsAttribute.isEmpty())
						pFileInfos->qsPreCommand = qsAttribute;
					qsAttribute = infoElement.attributeNode (SOURCE_PROPERTIES_PAUSE).value();
					if (!qsAttribute.isEmpty())
						pFileInfos->iPause = qsAttribute.toInt();
				}
				else if (SOURCE_OBJECT_TRANSCODE == infoName)	{
					if ( pFileInfos->pTranscodeInterface)
						delete pFileInfos->pTranscodeInterface;
					pFileInfos->pTranscodeInterface = new TranscodeInterface;
					transcodeNode = theElement.firstChild ();
					pFileInfos->pTranscodeInterface->readProjectFile (infoNode);
				}
				infoNode = infoNode.nextSibling ();
			}
			listFileInfos.append (pFileInfos);
		}
		else if (SOURCE_OBJECT_CHAPTERS == tagName)	{
			infoText = theElement.text ();
			listChapters = QStringList::split ( QString (","), infoText);
		}
		// Otherwise go to the next node ...
		sourceNode = sourceNode.nextSibling();
	}
	return true;
}

bool SourceFileEntry::writeProjectFile (QDomElement &theElement)
{
	// This check means that the slideshow has not yet been finished, thus we should not bother to
	// store this record since the mpeg does probably not exist.
	if (bIsSlideshow)	{
		QMessageBox::warning (NULL,QObject::tr("Warning"), QObject::tr ("Warning, the slideshow \n%1\nis not finished.\nThe SourceFileEntry will not be stored.").arg(qsDisplayName), QMessageBox::Ok, QMessageBox::NoButton);
		return true;
	}
	uint t;
	QDomDocument xmlDoc = theElement.ownerDocument();
	QDomElement sourceNode = xmlDoc.createElement( SOURCE_OBJECT );	// <FrameObject>

	QDomElement fileElement, infoElement, chapterElement, transcodeElement, propertiesElement; //tag;
	QDomElement tag;
	QDomText text;
	// Here we set the attributes of the <dvdauthor> tag
	if (!qsDisplayName.isNull())
		sourceNode.setAttribute( SOURCE_OBJECT_DISPLAY_NAME, qsDisplayName );
	if (bSoundSource)
		sourceNode.setAttribute( SOURCE_OBJECT_IS_SOUND_SOURCE, "true" );

	if (listFileInfos.count() > 0)	{
		for (t=0;t<listFileInfos.count();t++)	{
			infoElement = xmlDoc.createElement( SOURCE_OBJECT_INFO );
			if (!listFileInfos[t]->qsSize.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_SIZE, listFileInfos[t]->qsSize );
			if (!listFileInfos[t]->qsResolution.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_RESOLUTION, listFileInfos[t]->qsResolution );
			if (!listFileInfos[t]->qsFPS.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_FPS, listFileInfos[t]->qsFPS );
			if (!listFileInfos[t]->qsRatio.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_RATIO, listFileInfos[t]->qsRatio );
			if (!listFileInfos[t]->qsLength.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_LENGTH, listFileInfos[t]->qsLength );
			if (!listFileInfos[t]->qsFormat.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_FORMAT, listFileInfos[t]->qsFormat );
			if (!listFileInfos[t]->qsStatus.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_STATUS, listFileInfos[t]->qsStatus );
			if (!listFileInfos[t]->qsBits.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_BITS, listFileInfos[t]->qsBits );
			if (!listFileInfos[t]->qsSample.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_SAMPLE, listFileInfos[t]->qsSample );
			if (!listFileInfos[t]->qsBPS.isNull())
				infoElement.setAttribute( SOURCE_OBJECT_BPS, listFileInfos[t]->qsBPS );
			// Here we create another level in the XML tree for name and chapter ...
				// First the file name
				fileElement = xmlDoc.createElement( SOURCE_OBJECT_FILE_NAME );
				text = xmlDoc.createTextNode(listFileInfos[t]->qsFileName);
				fileElement.appendChild( text );
				infoElement.appendChild( fileElement );
				// Second the properties (Post / Pre, and Pause)
				propertiesElement = xmlDoc.createElement( SOURCE_OBJECT_PROPERTIES );
				if (!listFileInfos[t]->qsPostCommand.isNull())
					propertiesElement.setAttribute( SOURCE_PROPERTIES_POST, listFileInfos[t]->qsPostCommand );
				if (!listFileInfos[t]->qsPreCommand.isNull())
					propertiesElement.setAttribute( SOURCE_PROPERTIES_PRE, listFileInfos[t]->qsPreCommand );
				propertiesElement.setAttribute( SOURCE_PROPERTIES_PAUSE, QString ("%1").arg(listFileInfos[t]->iPause ));
				infoElement.appendChild( propertiesElement );
				// Then chapters if avail.
				if (listFileInfos[t]->listChapters.count() > 0)	{
					chapterElement = xmlDoc.createElement( SOURCE_OBJECT_CHAPTERS );
					text = xmlDoc.createTextNode(listFileInfos[t]->listChapters.join(QString(",")));
					chapterElement.appendChild( text );
					infoElement.appendChild( chapterElement );
				}
				// And finally the TranscodeInterface if any.
				if (listFileInfos[t]->pTranscodeInterface)	{
					transcodeElement = xmlDoc.createElement( SOURCE_OBJECT_TRANSCODE );
					listFileInfos[t]->pTranscodeInterface->writeProjectFile (transcodeElement);
					infoElement.appendChild( transcodeElement );
				}
			sourceNode.appendChild( infoElement );
		}
	}
	if (listChapters.count() > 0)	{
//printf ("SourceFileEntry::writeProjectFile <%d><%s>\n", listChapters.count (), (const char *)listChapters[0]);
		chapterElement = xmlDoc.createElement( SOURCE_OBJECT_CHAPTERS );
		sourceNode.appendChild( chapterElement );
		text = xmlDoc.createTextNode(listChapters.join(QString(",")));
		chapterElement.appendChild( text );
	}

	theElement.appendChild( sourceNode );
	return true;
}

SourceFileEntry & SourceFileEntry::operator = (SourceFileEntry &theOther)
{
	uint t;
	SourceFileInfo *pInfo;
	// First we take care of the entries in the list. Please note that we should keep the current ones around
	// in case we are cloning this entry.
	QValueList<SourceFileInfo *> listTemp2;
	for (t=0;t<theOther.listFileInfos.count();t++)	{
		pInfo = new SourceFileInfo ();
		*pInfo = *theOther.listFileInfos[t];
		listTemp2.append (pInfo);
	}
	// Now we should be save here to remove the entries ...	
	for (t=0;t<listFileInfos.count ();t++)
		delete listFileInfos[t];
	listFileInfos.clear();

	listFileInfos = listTemp2;

	qsDisplayName = theOther.qsDisplayName;
	listChapters  = theOther.listChapters;
	bSoundSource  = theOther.bSoundSource;
	bIsSlideshow  = theOther.bIsSlideshow;
	iTitleset     = theOther.iTitleset;
	iTitle        = theOther.iTitle;

	return *this;
}

SourceFileInfo & SourceFileInfo::operator = (SourceFileInfo &theOther)
{
	qsFileName   = theOther.qsFileName;
	qsSize       = theOther.qsSize;
	qsResolution = theOther.qsResolution;
	qsFPS        = theOther.qsFPS;
	qsRatio      = theOther.qsRatio;
	qsLength     = theOther.qsLength;
	qsFormat     = theOther.qsFormat;
	qsStatus     = theOther.qsStatus;
	qsBits       = theOther.qsBits;
	qsSample     = theOther.qsSample;
	qsBPS        = theOther.qsBPS;
	listChapters = theOther.listChapters;
	qsPreCommand = theOther.qsPreCommand;
	qsPostCommand= theOther.qsPostCommand;
	iPause       = theOther.iPause;
	if (theOther.pTranscodeInterface)	{
		if (!pTranscodeInterface)
			pTranscodeInterface = new TranscodeInterface ();
		*(pTranscodeInterface) = *(theOther.pTranscodeInterface);
	}
	else if (pTranscodeInterface)	{
		delete pTranscodeInterface;
		pTranscodeInterface = NULL;
	}
	return *this;
}

