/****************************************************************************
** MediaScanner class
**
** Created: Tue Jan 02 22:06:51 2004
**      by: Varol Okan using Kate
**
** This class spinns off a new thread and generate a Preview of the Job 
** which was set through MediaCreator::registerWithMediaScanner.
** 
** Once the preview is generated we will call the update function in 
** the main thread ( Currently MovieObject::updatePixmap () )
**
** if after 5 seconds after termination of the thread there are no new 
** requests in the queue then the thread will be termintaed to free 
** some memory.
**
****************************************************************************/

#include <qapplication.h>
#include <qimage.h>

#include "../sourcefileentry.h"
#include "mediascanner.h"
#include "mediacreator.h"
#include "mediainfo.h"


MediaScanner::MediaScanner()
	: QThread ()
{
	m_bHasFinished = false;
	m_bSemaphore   = false;
}

bool MediaScanner::hasFinished ()
{
	return m_bHasFinished;
}

void MediaScanner::append(ExecuteJob *pNewJob)
{
	// Please remember that this is executed in the main thread
	int iMaxWait = 0;
	// wait for max 3 seconds ...
	while ((m_bSemaphore) || (iMaxWait++ > 3000))
		usleep (1000);	// wait for 1 mSec
	// Status check if we reached max waiting time without success ...
	if (iMaxWait > 2999)
		return;
	m_bSemaphore = true;
	m_listExecuteFifo.append (pNewJob);
	m_bSemaphore = false;
	if (!running())	{
#if (QT_VERSION > 0x0301FF)
		start (QThread::LowPriority);
#else
		start ();
#endif
	}
}

void MediaScanner::run()
{
	// And this is executed in the child thread ...
	uint t;
	int iMaxWait;
	m_pMediaInfo = MediaCreator::createInfo ();
	QValueList<ExecuteJob *> listOfExecutedJobs;
	QImage theImage;
	// Generate the preview(s)
	while (m_listExecuteFifo.count())	{
		// I need the two loops because after running through the inner loop we see if the user 
		// will generate a new request within 5 seconds or not.
		while (m_listExecuteFifo.count())	{
			iMaxWait = 0;
			// wait for max 3 seconds ...
			while ((m_bSemaphore) || (iMaxWait++ > 3000))
				usleep (1000);	// wait for 1 mSec
			// Status check if we reached max waiting time without success ...
			if (iMaxWait > 2998)
				return;
			m_bSemaphore = true;
			ExecuteJob *pCurrentJob = m_listExecuteFifo.first();
			m_listExecuteFifo.remove (pCurrentJob);
			m_bSemaphore = false;
			if (pCurrentJob->pSourceFileInfo)	{
				m_pMediaInfo->setFileName (pCurrentJob->pSourceFileInfo->qsFileName);
				pCurrentJob->pSourceFileInfo->qsFormat     = m_pMediaInfo->getFormat (true);
				pCurrentJob->pSourceFileInfo->qsResolution = m_pMediaInfo->getResolutionString ();
				pCurrentJob->pSourceFileInfo->qsLength     = m_pMediaInfo->getLengthString ();
				pCurrentJob->pSourceFileInfo->qsSize       = m_pMediaInfo->getSizeString();
				pCurrentJob->pSourceFileInfo->qsRatio      = m_pMediaInfo->getRatio ();
				pCurrentJob->pSourceFileInfo->qsFPS        = QString ("%1").arg(m_pMediaInfo->getFPS());
				pCurrentJob->pSourceFileInfo->qsStatus     = m_pMediaInfo->getStatus();
				theImage = m_pMediaInfo->getScreenshot (pCurrentJob->iSecondsOffset);
				// Sanity check ... and copiing the image over.
				QSize sizeButton = pCurrentJob->pSourceFileInfo->pPreview->size();
				if (theImage.isNull())
					*pCurrentJob->pSourceFileInfo->pPreview = QImage().fromMimeSource( "error.jpg" ).smoothScale(sizeButton, QImage::ScaleFree);
				else
					*pCurrentJob->pSourceFileInfo->pPreview = theImage.smoothScale(sizeButton, QImage::ScaleMin);
				pCurrentJob->pSourceFileInfo->bUpdateInfo = true;
			}
			else	{
				m_pMediaInfo->setFileName (pCurrentJob->qsFileName);

				theImage = m_pMediaInfo->getScreenshot (pCurrentJob->iSecondsOffset);
				// Sanity check ...
				if (theImage.isNull())
					*pCurrentJob->pImage = QImage (QPixmap::fromMimeSource( "error.jpg" ).convertToImage());
				else
					*pCurrentJob->pImage = theImage;
			}
			listOfExecutedJobs.append (pCurrentJob);
			QApplication::postEvent(pCurrentJob->pOrigObject, new QTimerEvent(MEDIASCANNER_EVENT));
		}
		sleep (5);	// wait for 5 seconds ...
	}

	for (t=0;t<listOfExecutedJobs.count();t++)	
		delete listOfExecutedJobs[t];
	m_bHasFinished = true;
	delete m_pMediaInfo;
	m_pMediaInfo = NULL;
}

