
#include <qstring.h>
#include "log.h"

Log::Log (int iLogLevel)
{
	m_iLogLevel = iLogLevel;
	m_cBuffer  [0] = 0;
	m_cLogLevel[0] = 0;
}

Log::~Log ()
{

}

void Log::log2 (const char *string, ...)
{
	// This function is only called through the macros.
	printf ("%s%s", m_cBuffer, string);
	m_cBuffer  [0] = 0;
	m_cLogLevel[0] = 0;
}

void Log::logLevel (int iLogLevel)
{
	switch (iLogLevel)	{
	case logNone:
		sprintf (m_cLogLevel, "None   ");
	break;
	case logDebug:
		sprintf (m_cLogLevel, "None   ");
	break;
	case logInformation:
		sprintf (m_cLogLevel, "Info   ");
	break;
	case logWarning:
		sprintf (m_cLogLevel, "Warning");
	break;
	case logFatal:
		sprintf (m_cLogLevel, "Fatal  ");
	break;
	default:
		sprintf (m_cLogLevel, "Undef  ");
	}
}

void Log::log (const char *string, ...)
{
	log (logWarning, string);
}

void Log::log (int iLogLevel, const char *string, ...)
{
	logLevel (iLogLevel);
	printf ("%s%s", m_cLogLevel, string);
}

void Log::log (QString qsLog)
{
	log ((const char *)qsLog);
}

void Log::log (int iLogLevel, QString qsLog)
{
	log (iLogLevel, (const char *)qsLog);
}

void Log::line (const char *pFile, const char *pFunction, long iLine, int iLogLevel)
{
	logLevel (iLogLevel);
	if (iLogLevel >= m_iLogLevel)
		sprintf (m_cBuffer, "%s - %s::%s:%ld > ", m_cLogLevel, pFile, pFunction, iLine);
}

