/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
#include <qwmatrix.h>

#include "menuobject.h"
#include "imageobject.h"
#include "movieobject.h"

void DialogMatrix::slotClose()
{
    accept();
}


void DialogMatrix::slotZoom(int iPos)
{
	double fZoom   = (double)(iPos / 1000.0);
	if (fZoom > 1.0)
		fZoom = fZoom * 2.0 - 1.0;
	m_pEditZoom->setText (QString ("%1").arg(fZoom));
	m_pParent->modifiers()->fScaleX = fZoom;
	m_pParent->modifiers()->fScaleY = fZoom;
	m_pParent->update();
}

void DialogMatrix::slotRotate(int iPos)
{
	double fRotate = (double)(iPos / 10.0);
	m_pEditRotate->setText (QString ("%1").arg(fRotate));
	m_pParent->modifiers()->fRotate = fRotate;
	m_pParent->update();
}


void DialogMatrix::slotShearX(int iPos)
{
	double fShear = (double)(iPos / 1000.0);
	m_pEditShearX->setText (QString ("%1").arg(fShear));
	m_pParent->modifiers()->fShearX = fShear;
	m_pParent->update();
}


void DialogMatrix::slotShearY (int iPos)
{
	double fShear = (double)(iPos / 1000.0);
	m_pEditShearY->setText (QString ("%1").arg(fShear));
	m_pParent->modifiers()->fShearY = fShear;
	m_pParent->update();
}


void DialogMatrix::initMe(MenuObject *pParent)
{
	m_pParent = pParent;
	// Here we set the matrix values ...
	m_pSliderRotate->setRange (-1800, +1800);
	m_pSliderZoom  ->setRange (0, +2000);
	m_pSliderShearX->setRange (-2000, +2000);
	m_pSliderShearY->setRange (-2000, +2000);
	m_pSliderRotate->setValue ((int)(pParent->modifiers()->fRotate * 10.0)); // 0
	m_pSliderZoom  ->setValue ((int)(pParent->modifiers()->fScaleX * 1000.0)); // 1000
	m_pSliderShearX->setValue ((int)(pParent->modifiers()->fShearX * 1000.0)); // 1000
	m_pSliderShearY->setValue ((int)(pParent->modifiers()->fShearY * 1000.0)); // 1000
}

void DialogMatrix::slotSliderPressed()
{
	// Initiate the fast drawing algol of the MenuObject ...
	QMouseEvent fakeMouseEvent (QEvent::MouseButtonPress, QPoint(), Qt::LeftButton, Qt::LeftButton);
	m_pParent->mousePressEvent(&fakeMouseEvent);
}

void DialogMatrix::slotSliderReleased()
{
	QMouseEvent fakeMouseEvent (QEvent::MouseButtonPress, QPoint(), Qt::LeftButton, Qt::LeftButton);
	m_pParent->mouseReleaseEvent(&fakeMouseEvent);
	m_pParent->update();
	ImageObject theImage;
	MovieObject theMovie;
	if (m_pParent->objectType() == theImage.objectType())	{
		ImageObject *pImage = (ImageObject *)m_pParent;
		pImage->updatePixmap();
	}
	else if (m_pParent->objectType() == theMovie.objectType())	{
		MovieObject *pMovie = (MovieObject *)m_pParent;
		pMovie->updatePixmap();
	}
}

void DialogMatrix::slotDeleteObject( MenuObject * )
{
printf ("Kill me ...\n");
	accept();
}


