!/bin/sh 
 
echo [mpeg2video] >ffmpeg.cfg 
echo 'vhq = 1' >>ffmpeg.cfg 
echo 'mbd = 2' >>ffmpeg.cfg 
echo 'mbqmin = 2' >>ffmpeg.cfg 
echo 'mbqmax = 4' >>ffmpeg.cfg 
 
for file in "$@" 
 
do 
 
#Always do this, clean crappy avi's 
nice -19 mencoder -oac copy -ovc copy -ofps 25 -o output.avi ${file} 
 
nice -19 mplayer -ao pcm -vo null -vc dummy output.avi  
 
# if the incoming sound is at 44100 
# upsample the sound to 48000. 
# here we rely on the fact that sox will abort if the input 
# frequency is 48000. 
if sox audiodump.wav -r 48000 output.wav resample;  
then 
# add -e 48000,16,2 to the transcode command 
# so the sync adjustment is set by transcode to -1600@1000 
sound='-e 48000,16,2' 
# and make it into toolame mp2 format, nice! 
nice -19 toolame -p 2 -b 384 output.wav output.mp2 > /dev/null 2>&1  
rm -f audiodump.wav output.wav 
else 
# otherwise sound is 48000 
sound= 
nice -19 toolame -p 2 -b 384 audiodump.wav output.mp2 > /dev/null 2>&1 
# there will be a stub 44 byte long output.wav from the failed sox 
rm -f output.wav audiodump.wav 
fi 
 
# note the use of '-x mplayer,null' to remove export restrictions 
# imposed by bugs in ffmpeg which sometimes cause segfaults, boo! 
#transcode --nice 20 --print_status 500 -x mplayer,null -y ffmpeg,null -F mpeg2video $sound --export-prof dvd-pal -Z 720x576 -o output -i output.avi 
 
# WdW Mp2Enc 
transcode --nice 20 --print_status 100 -x mplayer,null -y mpeg2enc,null -V -w 8000 -F 8,"-E -10 -q 6 -R 0 -K tmpgenc" --export_asr 2 -Z 720x576 -o output -i output.avi 
 
rm -f output.avi 
 
# leave only .mpg files 
nice -19 mplex -f 8 -o ${file}.vob output.m2v output.mp2 
 
rm -f output.m2v output.mp2 ; 
 
# now you have .mpg files, all ready for dvdauthor. 
 
done 
 
 
# Convert Basis 25fps avi to PAL DVD 
