#!/bin/sh

cd qdvdauthor

designer=`find . -name "*.ui" | grep -v /.ui | wc -l`

# find header files which will generate a moc - file
object_header=`find . -name "*.h" -exec grep Q_OBJECT {} \; -print | grep -v Q_OBJECT | grep -v "/.ui/" | wc -l`

header=`find . -name "*.h" | grep -v CONFIG.h | grep -v /.ui/ | wc -l`

# 117 = 39 * header with Q_OBJECT (.ui/*.h has each one Q_OBJECT as well)
#  43 = 82 * header files (total number before compiling inclusive CONFIG.h and MEDIA_CONFIG.h)
#   0 = 67 * cpp files
# 105 = 21 * ui files
#   1 =  1 * qimage_collection.cpp
#  18 =  6 * cd qmake, make, entering, leaving, test ../bin, linking
#   1 =  1 * empty line (1 space)
#   2 =  1 * extra linking because line is too long.
#   1 =  1 * empty line
# - 2 - CONFIG.h, MEDIA_CONFIG.h = 285
# - 5 - header files only = xml_dvd.h, global.h, modifiers.h, qplayer_global.h, xml_qplayer.h
# + 3 - main.cpp, qplayer_main.cpp, slidermain.cpp
# ---
# 283
extra=19

count=$(($designer*5 +$object_header*2 + $header + $extra))

echo "designer=$designer*5 +object_header=$object_header*2 + header=$header + extra=$extra"

echo $count

