#!/bin/bash

# First we clean up a little ...
./clean.sh
rm qdvdauthor/CONFIG.h
rm qdvdauthor/qplayer/MEDIA_CONFIG.h

# here we print all *.ui files which are not conform to the Qt 3.1 version requirement
find . -name "*.ui" -exec grep DOCTYPE {} \; | grep -v 3.1

# Here we get the version number from the SPEC file.
version=`cat qdvdauthor.spec | grep Version | awk '{ print $2;}' | tr -d "\r\n"`
echo "$version"

// now we create the directory
CURRENT_PATH=`pwd`
cd ..
mkdir qdvdauthor-$version
cp -R $CURRENT_PATH/* qdvdauthor-$version/

# Finally we create the tarball
tar -czf qdvdauthor-$version.tar.gz qdvdauthor-$version


