/*
 * Decompiled with CFR 0.152.
 */
package drawgram;

import com.sun.jna.Library;
import com.sun.jna.Native;
import drawgram.DrawgramUserInterface;
import javax.swing.JOptionPane;
import util.TestFileNames;

public class DrawgramInterface {
    public boolean DrawgramRun(DrawgramUserInterface.DrawgramData inVals) {
        TestFileNames test = new TestFileNames();
        if (!test.FileAvailable(inVals.intree, "Intree")) {
            return false;
        }
        if (inVals.doplot) {
            String opt = test.FileAlreadyExists(inVals.plotfile, "Plotfile");
            if (opt == "q") {
                return false;
            }
            inVals.plotfileopt = opt == "a" ? "ab" : "wb";
        }
        String wherestr = "System.load";
        try {
            wherestr = "Native.loadLibrary";
            Drawgram Drawgram2 = (Drawgram)Native.loadLibrary("drawgram", Drawgram.class);
            Drawgram2.drawgram(inVals.intree, inVals.usefont, inVals.plotfile, inVals.plotfileopt, inVals.treegrows, inVals.treestyle, inVals.usebranchlengths, inVals.labelangle, inVals.scalebranchlength, inVals.branchlength, inVals.breadthdepthratio, inVals.stemltreedratio, inVals.chhttipspratio, inVals.xmarginratio, inVals.ymarginratio, inVals.ancnodes, inVals.doplot, inVals.finalplottype);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            String mapedLibName = System.mapLibraryName("drawgram");
            String libpath = inVals.librarypath;
            libpath = mapedLibName.contains("jnilib") ? String.valueOf(libpath) + "/libdrawgram.dylib" : (mapedLibName.contains("dll") ? String.valueOf(libpath) + "\\drawgram.dll" : String.valueOf(libpath) + "/libdrawgram.so");
            String msg = "Drawgram library not found in : ";
            msg = String.valueOf(msg) + libpath;
            msg = String.valueOf(msg) + " by ";
            msg = String.valueOf(msg) + wherestr;
            msg = String.valueOf(msg) + ". Error msg: ";
            msg = String.valueOf(msg) + e;
            System.out.println(msg);
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
            String path = System.getProperty("java.library.path");
            JOptionPane.showMessageDialog(null, path, "after error", 1);
            JOptionPane.showMessageDialog(null, mapedLibName, "after error", 1);
            return false;
        }
    }

    public static interface Drawgram
    extends Library {
        public void drawgram(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7, double var8, boolean var10, double var11, double var13, double var15, double var17, double var19, double var21, String var23, boolean var24, String var25);
    }
}

