/*
 * Decompiled with CFR 0.152.
 */
package drawtree;

import drawtree.DrawtreeInterface;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import util.DrawPreview;

public class DrawtreeUserInterface {
    private JFrame frmDrawtreeControls;
    private JButton InputTreeBtn;
    private JTextField IntreeTxt;
    private JTextField PlotTxt;
    private JButton plotBtn;
    private JComboBox cmbxPlotFont;
    private JRadioButton useLenY;
    private JRadioButton useLenN;
    private JComboBox cmbxLabelAngle;
    private JTextField treeRotationTxt;
    private JLabel lblTreeRotation;
    private JLabel lblFixedAngleOf;
    private JComboBox cmbxAngle;
    private JComboBox cmbxIterate;
    private JLabel lblAvoidOverlap;
    private JRadioButton avdOverY;
    private JRadioButton avdOverN;
    private JComboBox cmbxRescale;
    private JTextField relCharHgtTxt;
    private JLabel lblRegularizeTheAngles;
    private JRadioButton regangleY;
    private JRadioButton regangleN;
    private JLabel lblBranchScale;
    private JTextField branchScaleTxt;
    private JTextField treeArcTxt;
    private JRadioButton treeHRB;
    private JRadioButton treeVRB;
    private JLabel lblMaximumIterations;
    private JTextField IterationTxt;
    private JLabel lblFinalPlotType;
    private JComboBox cmbxFinalPlotType;
    private String filedir;
    private Color phylipBG;
    private JLabel lblMarginRatios;
    private JLabel lblXMarginRatio;
    private JTextField txtXMarginRatio;
    private JLabel lblYMarginRatio;
    private JTextField txtYMarginRatio;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DrawtreeUserInterface window = new DrawtreeUserInterface();
                    window.frmDrawtreeControls.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void ChooseFile(JTextField file) {
        JFileChooser fileChooser = new JFileChooser(this.filedir);
        int option = fileChooser.showOpenDialog(this.frmDrawtreeControls.getRootPane());
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.filedir = fileChooser.getCurrentDirectory().getAbsolutePath();
            file.setText(selectedFile.getPath());
        }
    }

    protected void ChoosePlot(JTextField file) {
        JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
        int option = fileChooser.showOpenDialog(this.frmDrawtreeControls.getRootPane());
        if (option == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            file.setText(selectedFile.getPath());
        }
    }

    protected void BranchLengthToggle(boolean uselength) {
        if (uselength) {
            this.useLenY.setSelected(true);
            this.useLenN.setSelected(false);
        } else {
            this.useLenY.setSelected(false);
            this.useLenN.setSelected(true);
        }
    }

    protected void AvoidOverlapToggle(boolean avoidoverlap) {
        if (avoidoverlap) {
            this.avdOverY.setSelected(true);
            this.avdOverN.setSelected(false);
        } else {
            this.avdOverY.setSelected(false);
            this.avdOverN.setSelected(true);
        }
    }

    protected void LabelAngleToggle() {
        if (this.cmbxLabelAngle.getSelectedItem().toString().contains("Fixed")) {
            this.lblFixedAngleOf.setEnabled(true);
            this.cmbxAngle.setEnabled(true);
        } else {
            this.lblFixedAngleOf.setEnabled(false);
            this.cmbxAngle.setEnabled(false);
        }
    }

    protected void IterationType() {
        if (this.cmbxIterate.getSelectedItem().toString().contains("No")) {
            this.lblRegularizeTheAngles.setEnabled(true);
            this.regangleY.setEnabled(true);
            this.regangleN.setEnabled(true);
            this.lblAvoidOverlap.setEnabled(false);
            this.avdOverY.setEnabled(false);
            this.avdOverN.setEnabled(false);
            this.lblMaximumIterations.setEnabled(false);
            this.IterationTxt.setEnabled(false);
            this.IterationTxt.setText("0");
        } else {
            this.lblRegularizeTheAngles.setEnabled(false);
            this.regangleY.setEnabled(false);
            this.regangleN.setEnabled(false);
            this.lblAvoidOverlap.setEnabled(true);
            this.avdOverY.setEnabled(true);
            this.avdOverN.setEnabled(true);
            this.lblMaximumIterations.setEnabled(true);
            this.IterationTxt.setEnabled(true);
            if (this.cmbxIterate.getSelectedItem().toString().contains("Equal")) {
                this.IterationTxt.setText("100");
            } else {
                this.IterationTxt.setText("50");
            }
        }
    }

    protected void ScaleValue() {
        if (this.cmbxRescale.getSelectedItem().toString().contains("Fixed")) {
            this.lblBranchScale.setEnabled(true);
            this.branchScaleTxt.setEnabled(true);
            this.branchScaleTxt.setEditable(true);
        } else {
            this.lblBranchScale.setEnabled(false);
            this.branchScaleTxt.setEnabled(false);
            this.branchScaleTxt.setEditable(false);
        }
    }

    protected void RegAngleToggle(boolean doregular) {
        if (doregular) {
            this.regangleY.setSelected(true);
            this.regangleN.setSelected(false);
        } else {
            this.regangleY.setSelected(false);
            this.regangleN.setSelected(true);
        }
    }

    protected void SweepLimit() {
        if (Math.abs(Double.parseDouble(this.treeArcTxt.getText())) > 360.0) {
            this.treeArcTxt.setText(Double.toString(Double.parseDouble(this.treeArcTxt.getText()) % 360.0));
        }
        if (Double.parseDouble(this.treeArcTxt.getText()) == 0.0) {
            this.treeArcTxt.setText(Double.toString(360.0));
        }
    }

    protected void RotationLimit() {
        if (Double.parseDouble(this.treeRotationTxt.getText()) > 360.0) {
            this.treeRotationTxt.setText(Double.toString(Double.parseDouble(this.treeRotationTxt.getText()) % 360.0));
        }
    }

    protected void TreeGrowToggle(boolean ishoriz) {
        if (ishoriz) {
            this.treeHRB.setSelected(true);
            this.treeVRB.setSelected(false);
        } else {
            this.treeHRB.setSelected(false);
            this.treeVRB.setSelected(true);
        }
    }

    protected boolean LaunchDrawtreeInterface(DrawtreeData inputdata) {
        inputdata.intree = this.IntreeTxt.getText();
        inputdata.plotfile = this.PlotTxt.getText();
        inputdata.plotfileopt = "wb";
        inputdata.usefont = this.cmbxPlotFont.getSelectedItem().toString();
        inputdata.usebranchlengths = this.useLenY.isSelected();
        inputdata.labeldirec = "middle";
        int i = 0;
        while (i < this.cmbxLabelAngle.getItemCount()) {
            if (this.cmbxLabelAngle.getItemAt(i).toString().contains(this.cmbxLabelAngle.getSelectedItem().toString())) {
                switch (this.cmbxLabelAngle.getSelectedIndex()) {
                    case 0: {
                        inputdata.labeldirec = "middle";
                        break;
                    }
                    case 1: {
                        inputdata.labeldirec = "fixed";
                        break;
                    }
                    case 2: {
                        inputdata.labeldirec = "radial";
                        break;
                    }
                    case 3: {
                        inputdata.labeldirec = "along";
                        break;
                    }
                    default: {
                        inputdata.labeldirec = "middle";
                    }
                }
            }
            ++i;
        }
        inputdata.labelangle = 0.0;
        i = 0;
        while (i < this.cmbxAngle.getItemCount()) {
            if (this.cmbxAngle.getItemAt(i).toString().contains(this.cmbxAngle.getSelectedItem().toString())) {
                switch (this.cmbxAngle.getSelectedIndex()) {
                    case 0: {
                        inputdata.labelangle = 0.0;
                        break;
                    }
                    case 1: {
                        inputdata.labelangle = 90.0;
                        break;
                    }
                    case 2: {
                        inputdata.labelangle = -90.0;
                        break;
                    }
                    default: {
                        inputdata.labelangle = 0.0;
                    }
                }
            }
            ++i;
        }
        inputdata.treegrows = this.treeHRB.isSelected() ? "horizontal" : "vertical";
        this.RotationLimit();
        this.SweepLimit();
        inputdata.treerotation = new Double(this.treeRotationTxt.getText());
        inputdata.treearc = new Double(this.treeArcTxt.getText());
        inputdata.iterationkind = "improve";
        i = 0;
        while (i < this.cmbxIterate.getItemCount()) {
            if (this.cmbxIterate.getItemAt(i).toString().contains(this.cmbxIterate.getSelectedItem().toString())) {
                switch (this.cmbxIterate.getSelectedIndex()) {
                    case 0: {
                        inputdata.iterationkind = "improve";
                        break;
                    }
                    case 1: {
                        inputdata.iterationkind = "nbody";
                        break;
                    }
                    case 2: {
                        inputdata.iterationkind = "no";
                        break;
                    }
                    default: {
                        inputdata.iterationkind = "improve";
                    }
                }
            }
            ++i;
        }
        inputdata.iterationcount = Integer.parseInt(this.IterationTxt.getText());
        inputdata.regularizeangles = this.regangleY.isSelected();
        inputdata.avoidlabeloverlap = this.avdOverY.isSelected();
        inputdata.branchrescale = false;
        inputdata.branchscaler = 1.0;
        i = 0;
        while (i < this.cmbxRescale.getItemCount()) {
            if (this.cmbxRescale.getItemAt(i).toString().contains(this.cmbxRescale.getSelectedItem().toString())) {
                switch (this.cmbxRescale.getSelectedIndex()) {
                    case 0: {
                        inputdata.branchrescale = true;
                        break;
                    }
                    case 1: {
                        inputdata.branchrescale = false;
                        inputdata.branchscaler = new Double(this.branchScaleTxt.getText());
                        break;
                    }
                    default: {
                        inputdata.branchrescale = true;
                    }
                }
            }
            ++i;
        }
        inputdata.relcharhgt = new Double(this.relCharHgtTxt.getText());
        inputdata.xmarginratio = new Double(this.txtXMarginRatio.getText());
        inputdata.ymarginratio = new Double(this.txtYMarginRatio.getText());
        inputdata.librarypath = System.getProperty("user.dir");
        switch (this.cmbxFinalPlotType.getSelectedIndex()) {
            case 0: {
                inputdata.finalplottype = "lw";
                break;
            }
            case 1: {
                inputdata.finalplottype = "pict";
                break;
            }
            case 2: {
                inputdata.finalplottype = "pcl";
                break;
            }
            case 3: {
                inputdata.finalplottype = "bmp";
                break;
            }
            case 4: {
                inputdata.finalplottype = "fig";
                break;
            }
            case 5: {
                inputdata.finalplottype = "idraw";
                break;
            }
            case 6: {
                inputdata.finalplottype = "vrml";
                break;
            }
            case 7: {
                inputdata.finalplottype = "pcx";
                break;
            }
            case 8: {
                inputdata.finalplottype = "tek";
                break;
            }
            case 9: {
                inputdata.finalplottype = "xbm";
                break;
            }
            case 10: {
                inputdata.finalplottype = "pov";
                break;
            }
            case 11: {
                inputdata.finalplottype = "ray";
                break;
            }
            case 12: {
                inputdata.finalplottype = "hp";
                break;
            }
            case 13: {
                inputdata.finalplottype = "decregis";
                break;
            }
            case 14: {
                inputdata.finalplottype = "epson";
                break;
            }
            case 15: {
                inputdata.finalplottype = "citoh";
                break;
            }
            case 16: {
                inputdata.finalplottype = "oki";
                break;
            }
            case 17: {
                inputdata.finalplottype = "houston";
                break;
            }
            case 18: {
                inputdata.finalplottype = "other";
                break;
            }
            default: {
                inputdata.finalplottype = "lw";
            }
        }
        DrawtreeInterface dg = new DrawtreeInterface();
        return dg.DrawtreeRun(inputdata);
    }

    public DrawtreeUserInterface() {
        this.initialize();
    }

    private void initialize() {
        this.filedir = System.getProperty("user.dir");
        this.phylipBG = new Color(204, 255, 255);
        UIManager.put("ComboBox.disabledBackground", this.phylipBG);
        this.frmDrawtreeControls = new JFrame();
        this.frmDrawtreeControls.getContentPane().setBackground(this.phylipBG);
        this.frmDrawtreeControls.setBackground(this.phylipBG);
        this.frmDrawtreeControls.setTitle("Drawtree");
        this.frmDrawtreeControls.setBounds(100, 100, 490, 610);
        this.frmDrawtreeControls.setDefaultCloseOperation(3);
        this.frmDrawtreeControls.getContentPane().setLayout(null);
        this.InputTreeBtn = new JButton("Input Tree");
        this.InputTreeBtn.setFont(new Font("Arial", 1, 13));
        this.InputTreeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.ChooseFile(DrawtreeUserInterface.this.IntreeTxt);
            }
        });
        this.InputTreeBtn.setBounds(10, 10, 117, 28);
        this.frmDrawtreeControls.getContentPane().add(this.InputTreeBtn);
        this.IntreeTxt = new JTextField();
        this.IntreeTxt.setFont(new Font("Arial", 0, 13));
        this.IntreeTxt.setText("intree");
        this.IntreeTxt.setBounds(131, 10, 333, 28);
        this.frmDrawtreeControls.getContentPane().add(this.IntreeTxt);
        this.IntreeTxt.setColumns(10);
        JSeparator separator = new JSeparator();
        separator.setBounds(0, 68, 485, 12);
        this.frmDrawtreeControls.getContentPane().add(separator);
        this.plotBtn = new JButton("Plot File");
        this.plotBtn.setFont(new Font("Arial", 1, 13));
        this.plotBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DrawtreeUserInterface.this.ChooseFile(DrawtreeUserInterface.this.PlotTxt);
            }
        });
        this.plotBtn.setBounds(10, 39, 117, 28);
        this.frmDrawtreeControls.getContentPane().add(this.plotBtn);
        this.PlotTxt = new JTextField();
        this.PlotTxt.setFont(new Font("Arial", 0, 13));
        this.PlotTxt.setText("plotfile.ps");
        this.PlotTxt.setBounds(131, 39, 333, 28);
        this.frmDrawtreeControls.getContentPane().add(this.PlotTxt);
        this.PlotTxt.setColumns(10);
        JLabel lblNewLabel_2 = new JLabel("PostScript Font:");
        lblNewLabel_2.setFont(new Font("Arial", 1, 13));
        lblNewLabel_2.setHorizontalAlignment(4);
        lblNewLabel_2.setBounds(23, 87, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(lblNewLabel_2);
        this.cmbxPlotFont = new JComboBox();
        this.cmbxPlotFont.setFont(new Font("Arial", 0, 13));
        this.cmbxPlotFont.setModel(new DefaultComboBoxModel<String>(new String[]{"Times-Roman", "Times-Bold", "Helvetica", "Helvetica-Bold", "Courier", "Courier-Bold", "AvantGarde-Book", "AvantGarde-BookOblique", "AvantGarde-Demi", "AvantGarde-DemiOblique", "Bookman-Light", "Bookman-LightItalic", "Bookman-Demi", "Bookman-DemiItalic", "Courier-Oblique", "Courier-BoldOblique", "Helvetica-Oblique", "Helvetica-BoldOblique", "Helvetica-Narrow", "Helvetica-Narrow-Oblique", "Helvetica-Narrow-Bold", "Helvetica-Narrow-BoldOblique", "NewCenturySchlbk-Roman", "NewCenturySchlbk-Italic", "NewCenturySchlbk-Bold", "NewCenturySchlbk-BoldItalic", "Palatino-Roman", "Palatino-Italic", "Palatino-Bold", "Palatino-BoldItalic", "Times-BoldItalic", "Times-Italic", "ZapfChancery-MediumItalic"}));
        this.cmbxPlotFont.setBounds(239, 82, 216, 27);
        this.cmbxPlotFont.setRenderer(new DefaultListCellRenderer(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.frmDrawtreeControls.getContentPane().add(this.cmbxPlotFont);
        JLabel lblUseBranchLengths = new JLabel("Use branch lengths:");
        lblUseBranchLengths.setFont(new Font("Arial", 1, 13));
        lblUseBranchLengths.setHorizontalAlignment(11);
        lblUseBranchLengths.setBounds(23, 145, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(lblUseBranchLengths);
        this.useLenY = new JRadioButton("Yes");
        this.useLenY.setFont(new Font("Arial", 1, 13));
        this.useLenY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.BranchLengthToggle(true);
            }
        });
        this.useLenY.setSelected(true);
        this.useLenY.setBounds(239, 142, 71, 23);
        this.useLenY.setBackground(this.phylipBG);
        this.frmDrawtreeControls.getContentPane().add(this.useLenY);
        this.useLenN = new JRadioButton("No");
        this.useLenN.setFont(new Font("Arial", 1, 13));
        this.useLenN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.BranchLengthToggle(false);
            }
        });
        this.useLenN.setBounds(312, 142, 54, 23);
        this.useLenN.setBackground(this.phylipBG);
        this.frmDrawtreeControls.getContentPane().add(this.useLenN);
        this.lblTreeRotation = new JLabel("Angle of tree:");
        this.lblTreeRotation.setFont(new Font("Arial", 1, 13));
        this.lblTreeRotation.setHorizontalAlignment(11);
        this.lblTreeRotation.setBounds(23, 232, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(this.lblTreeRotation);
        this.treeRotationTxt = new JTextField();
        this.treeRotationTxt.setFont(new Font("Arial", 0, 13));
        this.treeRotationTxt.setHorizontalAlignment(4);
        this.treeRotationTxt.setText("90.0");
        this.treeRotationTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.RotationLimit();
            }
        });
        this.treeRotationTxt.setBounds(239, 227, 89, 27);
        this.frmDrawtreeControls.getContentPane().add(this.treeRotationTxt);
        this.treeRotationTxt.setColumns(10);
        JLabel lblTreeArc = new JLabel("Arc of tree:");
        lblTreeArc.setFont(new Font("Arial", 1, 13));
        lblTreeArc.setHorizontalAlignment(4);
        lblTreeArc.setBounds(23, 261, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(lblTreeArc);
        this.treeArcTxt = new JTextField();
        this.treeArcTxt.setFont(new Font("Arial", 0, 13));
        this.treeArcTxt.setHorizontalAlignment(4);
        this.treeArcTxt.setText("360.0");
        this.treeArcTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.SweepLimit();
            }
        });
        this.treeArcTxt.setBounds(239, 256, 89, 27);
        this.frmDrawtreeControls.getContentPane().add(this.treeArcTxt);
        this.treeArcTxt.setColumns(10);
        JLabel lblBranchLen = new JLabel(" (if present)");
        lblBranchLen.setFont(new Font("Arial", 1, 13));
        lblBranchLen.setBounds(366, 145, 89, 16);
        lblBranchLen.setBackground(this.phylipBG);
        this.frmDrawtreeControls.getContentPane().add(lblBranchLen);
        JButton btnPlotFile = new JButton("Create Plot File");
        btnPlotFile.setFont(new Font("Arial", 1, 13));
        btnPlotFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeData inputdata = new DrawtreeData();
                inputdata.doplot = true;
                boolean retval = DrawtreeUserInterface.this.LaunchDrawtreeInterface(inputdata);
            }
        });
        btnPlotFile.setBounds(162, 551, 156, 29);
        this.frmDrawtreeControls.getContentPane().add(btnPlotFile);
        JButton btnPreview = new JButton("Preview");
        btnPreview.setFont(new Font("Arial", 1, 13));
        btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeData inputdata = new DrawtreeData();
                inputdata.doplot = false;
                boolean retval = DrawtreeUserInterface.this.LaunchDrawtreeInterface(inputdata);
                if (retval) {
                    String title = "Preview: " + DrawtreeUserInterface.this.PlotTxt.getText();
                    String curDir = System.getProperty("user.dir");
                    curDir = String.valueOf(curDir) + "/JavaPreview.ps";
                    new DrawPreview(title, curDir);
                }
            }
        });
        btnPreview.setBounds(23, 551, 117, 29);
        this.frmDrawtreeControls.getContentPane().add(btnPreview);
        JButton btnQuit = new JButton("Quit");
        btnQuit.setFont(new Font("Arial", 1, 13));
        btnQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        btnQuit.setBounds(340, 551, 117, 29);
        this.frmDrawtreeControls.getContentPane().add(btnQuit);
        JLabel lblAngleOfLabels = new JLabel("Angle of labels:");
        lblAngleOfLabels.setFont(new Font("Arial", 1, 13));
        lblAngleOfLabels.setHorizontalAlignment(4);
        lblAngleOfLabels.setBounds(23, 174, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(lblAngleOfLabels);
        this.cmbxLabelAngle = new JComboBox();
        this.cmbxLabelAngle.setFont(new Font("Arial", 0, 13));
        this.cmbxLabelAngle.setModel(new DefaultComboBoxModel<String>(new String[]{"Middle of Label", "Fixed", "Radial", "Along Branches"}));
        this.cmbxLabelAngle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.LabelAngleToggle();
            }
        });
        this.cmbxLabelAngle.setBounds(239, 169, 181, 27);
        this.cmbxLabelAngle.setRenderer(new DefaultListCellRenderer(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.frmDrawtreeControls.getContentPane().add(this.cmbxLabelAngle);
        this.lblFixedAngleOf = new JLabel("Fixed label angle:");
        this.lblFixedAngleOf.setFont(new Font("Arial", 1, 13));
        this.lblFixedAngleOf.setEnabled(false);
        this.lblFixedAngleOf.setHorizontalAlignment(4);
        this.lblFixedAngleOf.setBounds(23, 203, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(this.lblFixedAngleOf);
        this.cmbxAngle = new JComboBox();
        this.cmbxAngle.setFont(new Font("Arial", 0, 13));
        this.cmbxAngle.setEnabled(false);
        this.cmbxAngle.setModel(new DefaultComboBoxModel<String>(new String[]{"    0.0", "  90.0", "-90.0"}));
        this.cmbxAngle.setBounds(239, 198, 92, 27);
        this.cmbxAngle.setRenderer(new DefaultListCellRenderer(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.frmDrawtreeControls.getContentPane().add(this.cmbxAngle);
        JLabel lblIterateToImprove = new JLabel("Iterate to improve tree:");
        lblIterateToImprove.setFont(new Font("Arial", 1, 13));
        lblIterateToImprove.setHorizontalAlignment(4);
        lblIterateToImprove.setBounds(23, 290, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(lblIterateToImprove);
        this.cmbxIterate = new JComboBox();
        this.cmbxIterate.setFont(new Font("Arial", 0, 13));
        this.cmbxIterate.setModel(new DefaultComboBoxModel<String>(new String[]{"Equal-Daylight algorithm", "n-Body algorithm", "No"}));
        this.cmbxIterate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.IterationType();
            }
        });
        this.cmbxIterate.setBounds(239, 285, 216, 27);
        this.cmbxIterate.setRenderer(new DefaultListCellRenderer(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.frmDrawtreeControls.getContentPane().add(this.cmbxIterate);
        this.lblMaximumIterations = new JLabel("Maximum iterations:");
        this.lblMaximumIterations.setFont(new Font("Arial", 1, 13));
        this.lblMaximumIterations.setHorizontalAlignment(11);
        this.lblMaximumIterations.setBounds(23, 319, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(this.lblMaximumIterations);
        this.IterationTxt = new JTextField();
        this.IterationTxt.setFont(new Font("Arial", 0, 13));
        this.IterationTxt.setText("100");
        this.IterationTxt.setBounds(239, 314, 46, 27);
        this.frmDrawtreeControls.getContentPane().add(this.IterationTxt);
        this.IterationTxt.setColumns(10);
        this.lblAvoidOverlap = new JLabel("Try to avoid label overlap:");
        this.lblAvoidOverlap.setFont(new Font("Arial", 1, 13));
        this.lblAvoidOverlap.setHorizontalAlignment(4);
        this.lblAvoidOverlap.setBounds(23, 377, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(this.lblAvoidOverlap);
        this.avdOverY = new JRadioButton("Yes");
        this.avdOverY.setFont(new Font("Arial", 1, 13));
        this.avdOverY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.AvoidOverlapToggle(true);
            }
        });
        this.avdOverY.setBounds(239, 374, 71, 23);
        this.avdOverY.setBackground(this.phylipBG);
        this.frmDrawtreeControls.getContentPane().add(this.avdOverY);
        this.avdOverN = new JRadioButton("No");
        this.avdOverN.setFont(new Font("Arial", 1, 13));
        this.avdOverN.setSelected(true);
        this.avdOverN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.AvoidOverlapToggle(false);
            }
        });
        this.avdOverN.setBounds(312, 374, 54, 23);
        this.avdOverN.setBackground(this.phylipBG);
        this.frmDrawtreeControls.getContentPane().add(this.avdOverN);
        JLabel lblBranchLengths = new JLabel("Branch lengths:");
        lblBranchLengths.setFont(new Font("Arial", 1, 13));
        lblBranchLengths.setHorizontalAlignment(4);
        lblBranchLengths.setBounds(23, 406, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(lblBranchLengths);
        this.cmbxRescale = new JComboBox();
        this.cmbxRescale.setFont(new Font("Arial", 0, 13));
        this.cmbxRescale.setModel(new DefaultComboBoxModel<String>(new String[]{"Automatically rescale", "Fixed scale"}));
        this.cmbxRescale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.ScaleValue();
            }
        });
        this.cmbxRescale.setBounds(239, 401, 216, 27);
        this.cmbxRescale.setRenderer(new DefaultListCellRenderer(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.frmDrawtreeControls.getContentPane().add(this.cmbxRescale);
        this.lblBranchScale = new JLabel("Branch scale:");
        this.lblBranchScale.setFont(new Font("Arial", 1, 13));
        this.lblBranchScale.setEnabled(false);
        this.lblBranchScale.setHorizontalAlignment(4);
        this.lblBranchScale.setBounds(23, 435, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(this.lblBranchScale);
        this.branchScaleTxt = new JTextField();
        this.branchScaleTxt.setFont(new Font("Arial", 0, 13));
        this.branchScaleTxt.setEditable(false);
        this.branchScaleTxt.setEnabled(false);
        this.branchScaleTxt.setText("0.15");
        this.branchScaleTxt.setBounds(239, 430, 63, 27);
        this.frmDrawtreeControls.getContentPane().add(this.branchScaleTxt);
        this.branchScaleTxt.setColumns(10);
        JLabel lblNewLabel_3 = new JLabel("Relative character height:");
        lblNewLabel_3.setFont(new Font("Arial", 1, 13));
        lblNewLabel_3.setHorizontalAlignment(11);
        lblNewLabel_3.setBounds(23, 464, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(lblNewLabel_3);
        this.relCharHgtTxt = new JTextField();
        this.relCharHgtTxt.setFont(new Font("Arial", 0, 13));
        this.relCharHgtTxt.setText("0.3333");
        this.relCharHgtTxt.setBounds(239, 459, 63, 27);
        this.frmDrawtreeControls.getContentPane().add(this.relCharHgtTxt);
        this.relCharHgtTxt.setColumns(10);
        this.lblRegularizeTheAngles = new JLabel("Regularize the angles:");
        this.lblRegularizeTheAngles.setEnabled(false);
        this.lblRegularizeTheAngles.setFont(new Font("Arial", 1, 13));
        this.lblRegularizeTheAngles.setHorizontalAlignment(4);
        this.lblRegularizeTheAngles.setBounds(23, 348, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(this.lblRegularizeTheAngles);
        this.regangleY = new JRadioButton("Yes");
        this.regangleY.setEnabled(false);
        this.regangleY.setFont(new Font("Arial", 1, 13));
        this.regangleY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.RegAngleToggle(true);
            }
        });
        this.regangleY.setBounds(239, 345, 71, 23);
        this.regangleY.setBackground(this.phylipBG);
        this.frmDrawtreeControls.getContentPane().add(this.regangleY);
        this.regangleN = new JRadioButton("No");
        this.regangleN.setEnabled(false);
        this.regangleN.setFont(new Font("Arial", 1, 13));
        this.regangleN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.RegAngleToggle(false);
            }
        });
        this.regangleN.setSelected(true);
        this.regangleN.setBounds(312, 345, 54, 23);
        this.regangleN.setBackground(this.phylipBG);
        this.frmDrawtreeControls.getContentPane().add(this.regangleN);
        JLabel label = new JLabel("Tree grows:");
        label.setFont(new Font("Arial", 1, 13));
        label.setHorizontalAlignment(11);
        label.setBounds(23, 116, 204, 16);
        this.frmDrawtreeControls.getContentPane().add(label);
        this.treeHRB = new JRadioButton("Horizontally");
        this.treeHRB.setFont(new Font("Arial", 1, 13));
        this.treeHRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.TreeGrowToggle(true);
            }
        });
        this.treeHRB.setBounds(239, 113, 117, 23);
        this.treeHRB.setBackground(this.phylipBG);
        this.frmDrawtreeControls.getContentPane().add(this.treeHRB);
        this.treeVRB = new JRadioButton("Vertically");
        this.treeVRB.setFont(new Font("Arial", 1, 13));
        this.treeVRB.setSelected(true);
        this.treeVRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawtreeUserInterface.this.TreeGrowToggle(false);
            }
        });
        this.treeVRB.setBounds(356, 113, 111, 23);
        this.treeVRB.setBackground(this.phylipBG);
        this.frmDrawtreeControls.getContentPane().add(this.treeVRB);
        this.lblFinalPlotType = new JLabel("Final plot file type:");
        this.lblFinalPlotType.setHorizontalAlignment(11);
        this.lblFinalPlotType.setFont(new Font("Arial", 1, 13));
        this.lblFinalPlotType.setBounds(16, 493, 211, 16);
        this.frmDrawtreeControls.getContentPane().add(this.lblFinalPlotType);
        this.cmbxFinalPlotType = new JComboBox();
        this.cmbxFinalPlotType.setModel(new DefaultComboBoxModel<String>(new String[]{"Postscript", "PICT", "PCL", "Windows BMP", "FIG 2.0", "Idraw", "VRML", "PCX", "Tek4010", "X Bitmap", "POVRAY 3D", "Rayshade 3D", "HPGL", "DEC ReGIS", "Epson MX-80", "Prowriter/Imagewriter", "Okidata dot-matrix", "Houston Instruments plotter", "other"}));
        this.cmbxFinalPlotType.setSelectedIndex(0);
        this.cmbxFinalPlotType.setFont(new Font("Arial", 0, 13));
        this.cmbxFinalPlotType.setBounds(239, 487, 216, 28);
        this.cmbxFinalPlotType.setRenderer(new DefaultListCellRenderer(){

            @Override
            public void paint(Graphics g) {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                super.paint(g);
            }
        });
        this.frmDrawtreeControls.getContentPane().add(this.cmbxFinalPlotType);
        this.lblMarginRatios = new JLabel("Page margin ratios:");
        this.lblMarginRatios.setHorizontalAlignment(4);
        this.lblMarginRatios.setFont(new Font("Arial", 1, 13));
        this.lblMarginRatios.setBounds(81, 522, 146, 16);
        this.frmDrawtreeControls.getContentPane().add(this.lblMarginRatios);
        this.lblXMarginRatio = new JLabel("X:");
        this.lblXMarginRatio.setHorizontalAlignment(4);
        this.lblXMarginRatio.setFont(new Font("Arial", 1, 13));
        this.lblXMarginRatio.setBounds(230, 522, 26, 16);
        this.frmDrawtreeControls.getContentPane().add(this.lblXMarginRatio);
        this.txtXMarginRatio = new JTextField();
        this.txtXMarginRatio.setText("0.08");
        this.txtXMarginRatio.setColumns(10);
        this.txtXMarginRatio.setBounds(256, 516, 69, 28);
        this.frmDrawtreeControls.getContentPane().add(this.txtXMarginRatio);
        this.lblYMarginRatio = new JLabel("Y:");
        this.lblYMarginRatio.setHorizontalAlignment(4);
        this.lblYMarginRatio.setFont(new Font("Arial", 1, 13));
        this.lblYMarginRatio.setBounds(328, 522, 26, 16);
        this.frmDrawtreeControls.getContentPane().add(this.lblYMarginRatio);
        this.txtYMarginRatio = new JTextField();
        this.txtYMarginRatio.setText("0.08");
        this.txtYMarginRatio.setColumns(10);
        this.txtYMarginRatio.setBounds(354, 516, 69, 28);
        this.frmDrawtreeControls.getContentPane().add(this.txtYMarginRatio);
    }

    public class DrawtreeData {
        String intree;
        String plotfile;
        String plotfileopt;
        String usefont;
        String treegrows;
        boolean usebranchlengths;
        String labeldirec;
        Double labelangle;
        Double treerotation;
        Double treearc;
        String iterationkind;
        int iterationcount;
        boolean regularizeangles;
        boolean avoidlabeloverlap;
        boolean branchrescale;
        Double branchscaler;
        Double relcharhgt;
        Double xmarginratio;
        Double ymarginratio;
        String librarypath;
        boolean doplot;
        String finalplottype;
    }
}

