#!/usr/bin/perl
#------------------------------------------------------------------------------
# Project  : Oracle to Postgresql converter
# Name     : ora2pg.pl
# Author   : Gilles Darold, gilles@darold.net
# Copyright: Copyright (c) 2000-2009 : Gilles Darold - All rights reserved -
# Function : Script used to convert Oracle Database to PostgreSQL
# Usage    : ora2pg.pl configuration_file
#------------------------------------------------------------------------------
use strict;

use Ora2Pg;

my $VERSION = '5.5';

# Must have a configuration file as command line parameter
if ( ($#ARGV < 0) || !-f $ARGV[0]) {
	&usage();
}

# Create an instance of the Ora2Pg perl module
my $schema = new Ora2Pg (
	config => $ARGV[0],
);

# Proceed to Oracle DB extraction following
# configuration file definitions.
$schema->export_schema();

exit(0);


sub usage
{
	print qq{
Ora2Pg, version $VERSION

Usage: ora2pg.pl path_to_configuration_file
       See README for more help

};
	exit 0;

}

