/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
USERES("duke.res");
USEFORM("main.cpp", Form1);
USEUNIT("D3DRender.cpp");
USEUNIT("View.cpp");
USEUNIT("DirectDraw.cpp");
USEUNIT("Math3d.cpp");
USEUNIT("poly.cpp");
USEUNIT("Texture.cpp");
USEUNIT("Vertex.cpp");
USEUNIT("Direct3d.cpp");
USEUNIT("map.cpp");
USEUNIT("GroupFile.cpp");
USEUNIT("DirectInput.cpp");
USEUNIT("art.cpp");
USEUNIT("DSoundEngine.cpp");
USEUNIT("console.cpp");
USEUNIT("music.cpp");
USEUNIT("FixPoly.cpp");
USEUNIT("RTSFile.cpp");
USEUNIT("anm.cpp");
USEUNIT("SoftRender.cpp");
USEUNIT("OpenGLRender.cpp");
USEASM("div0.asm");
USEUNIT("Render.cpp");
USEUNIT("Sound.cpp");
USELIB("..\..\Lib\dxguid.lib");
USELIB("..\..\Lib\dinput.lib");
//---------------------------------------------------------------------------
HINSTANCE hInst;
extern int graphicalConsole;
extern HANDLE consoleScreenBuf;

//---------------------------------------------------------------------------
WINAPI WinMain(HINSTANCE _hInst, HINSTANCE, LPSTR cmdLine, int)
{
    hInst=_hInst;
    if (strcmp(cmdLine,"-g"))
    {
        graphicalConsole=0;
        AllocConsole();
        consoleScreenBuf=CreateConsoleScreenBuffer(
            GENERIC_READ|GENERIC_WRITE,0,NULL,
            CONSOLE_TEXTMODE_BUFFER,NULL);
        SetConsoleActiveScreenBuffer(consoleScreenBuf);
        SetConsoleTitle("Duke Nukem 3D Console");
        SetConsoleMode(consoleScreenBuf,0);
    }
    try
    {
         Application->Initialize();
         Application->Title = "Duke Nukem 3D";
         Application->CreateForm(__classid(TForm1), &Form1);
         Application->Run();
    }
    catch (Exception &exception)
    {
         Application->ShowException(&exception);
    }
    return 0;
}
//---------------------------------------------------------------------------
