/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#pragma hdrstop
#include "Math3D.h"
#include <math.h>

void MatrixRotateX(D3DMATRIX& mat,float a)
{
	D3DMATRIX temp;	
	float s=sin(a);
	float c=cos(a);
	
	temp._12=mat._12*c+mat._13*s;
	temp._22=mat._22*c+mat._23*s;
	temp._32=mat._32*c+mat._33*s;
	temp._42=mat._42*c+mat._43*s;
	temp._13=mat._12*-s+mat._13*c;
	temp._23=mat._22*-s+mat._23*c;
	temp._33=mat._32*-s+mat._33*c;
	temp._43=mat._42*-s+mat._43*c;
	
	mat._12=temp._12; mat._22=temp._22; mat._32=temp._32;
	mat._42=temp._42; mat._13=temp._13; mat._23=temp._23;
	mat._33=temp._33; mat._43=temp._43;
}

void MatrixRotateY(D3DMATRIX& mat,float a)
{
	D3DMATRIX temp;	
	float s=sin(a);
	float c=cos(a);
	
	temp._11=mat._11*c+mat._13*-s;
	temp._21=mat._21*c+mat._23*-s;
	temp._31=mat._31*c+mat._33*-s;
	temp._41=mat._41*c+mat._43*-s;
	temp._13=mat._11*s+mat._13*c;
	temp._23=mat._21*s+mat._23*c;
	temp._33=mat._31*s+mat._33*c;
	temp._43=mat._41*s+mat._43*c;
	
	mat._11=temp._11; mat._21=temp._21; mat._31=temp._31;
	mat._41=temp._41; mat._13=temp._13; mat._23=temp._23;
	mat._33=temp._33; mat._43=temp._43;
}

void MatrixRotateZ(D3DMATRIX& mat,float a)
{
	D3DMATRIX temp;	
	float s=sin(a);
	float c=cos(a);
	
	temp._11=mat._11*c+mat._12*s;
	temp._21=mat._21*c+mat._22*s;
	temp._31=mat._31*c+mat._32*s;
	temp._41=mat._41*c+mat._42*s;
	temp._12=mat._11*-s+mat._12*c;
	temp._22=mat._21*-s+mat._22*c;
	temp._32=mat._31*-s+mat._32*c;
	temp._42=mat._41*-s+mat._42*c;
	
	mat._11=temp._11; mat._21=temp._21; mat._31=temp._31;
	mat._41=temp._41; mat._12=temp._12; mat._22=temp._22;
	mat._32=temp._32; mat._42=temp._42;
}

void TransformVector(Vector& v,D3DMATRIX& mat)
{
	v=Vector(v.x*mat._11+v.y*mat._12+v.z*mat._13+mat._41,
			 v.x*mat._21+v.y*mat._22+v.z*mat._23+mat._42,
			 v.x*mat._31+v.y*mat._32+v.z*mat._33+mat._43);
}
