/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------
#include <vcl.h>
#include <mmsystem.h>
#pragma hdrstop
#include <stdlib.h>
#include <stdio.h>
#include "console.h"

#include "DSoundEngine.h"

DirectSoundEngine::DirectSoundEngine(HWND hWnd)
{
    init=0; lpDS=NULL;
    HMODULE dsound=LoadLibrary("dsound.dll");
    if (dsound==NULL)
    {
        cprintf("DirectSound is not installed\n");
        return;
    }
    HRESULT WINAPI (*dsc)(LPCGUID,LPDIRECTSOUND*,LPUNKNOWN)=
        (HRESULT WINAPI (*)(LPCGUID,LPDIRECTSOUND*,LPUNKNOWN))
        GetProcAddress(dsound,"DirectSoundCreate");
    if (dsc==NULL)
    {
        cprintf("DirectSound is not installed\n");
        return;
    }
    if (dsc(NULL,&lpDS,NULL)!=DS_OK)
    {
        cprintf("Could not initialize DirectSound\n");
        lpDS=NULL;
        return;
    }
    if (lpDS->SetCooperativeLevel(hWnd,DSSCL_PRIORITY)!=DS_OK)
    {
        cprintf("Could not set DirectSound cooperative level\n");
        lpDS->Release(); lpDS=NULL;
        return;
    }
    cprintf("DirectSound initialization OK\n");
    init=1;
    soundMute=0;
}

DirectSoundEngine::~DirectSoundEngine()
{
    if (lpDS)
    {
        lpDS->Release();
        cprintf("DirectSound deinitialized\n");
    }
}

int DirectSoundEngine::Initialized()
{
    return init;
}

void DirectSoundEngine::SetChannelType(int c,int t)
{
    ch[c].type=t;
}

int DirectSoundEngine::PlaySound(Sound* snd,int t,int pri,int loop)
{
    if (!init) return -1;
    if (soundMute) return -1;
    if (!snd) return -1;
    int c=-1;
    for (int i=0;i<SOUND_CHANNELS;i++)
    {
        if ((ch[i].type==t)&&(ch[i].buf==NULL))
        {
            c=i;
            break;
        }
    }
    if (c==-1)
    {
        int pri=-9999;
        unsigned long start;
        for (int i=0;i<SOUND_CHANNELS;i++)
        {
            if (ch[i].type==t)
            {
                if (ch[i].pri>pri)
                {
                    c=i;
                    pri=ch[i].pri;
                    start=ch[i].start;
                }
                else if ((ch[i].pri==pri)&&(ch[i].start<start))
                {
                    c=i;
                    start=ch[i].start;
                }
            }
        }
        if (c==-1) return -1;
    }
    if (ch[c].buf)
    {
        ch[c].buf->Stop();
        ch[c].buf->Release();
        ch[c].buf=NULL;
    }
    DSBUFFERDESC1 d;
    memset(&d,0,sizeof(d));
    d.dwSize=sizeof(d);
    d.dwFlags=0;
    d.dwBufferBytes=snd->len;
    d.lpwfxFormat=&snd->format;
    if (lpDS->CreateSoundBuffer((DSBUFFERDESC*)&d,&ch[c].buf,NULL)!=DS_OK)
    {
        cprintf("DirectSound error: Could not create buffer\n");
        ch[c].buf=NULL;
        return -1;
    }
    if (!ch[c].buf)
    {
        cprintf("DirectSound error: Could not create buffer\n");
        return -1;
    }
    short *ptr1,*ptr2;
    unsigned long len1,len2;
    if (ch[c].buf->Lock(0,snd->len,(void**)&ptr1,&len1,(void**)&ptr2,&len2,0)!=DS_OK)
    {
        cprintf("DirectSound error: Could not lock buffer\n");
        ch[c].buf->Release();
        ch[c].buf=NULL;
        return -1;
    }
    memcpy(ptr1,snd->data,len1);
    ch[c].buf->Unlock(ptr1,len1,ptr2,len2);
    if (ch[c].buf->Play(0,0,loop?DSBPLAY_LOOPING:0)!=DS_OK)
    {
        cprintf("DirectSound error: Play failed\n");
        ch[c].buf->Release();
        ch[c].buf=NULL;
        return -1;
    }
    ch[c].start=GetTickCount();
    return c;
}

void DirectSoundEngine::StopSound(int c)
{
    if (!init) return;
    if ((c<0)||(c>=SOUND_CHANNELS)) return;
    if (ch[c].buf)
    {
        ch[c].buf->Stop();
        ch[c].buf->Release();
        ch[c].buf=NULL;
    }
}

void DirectSoundEngine::SoundMute(int mute)
{
    soundMute=mute;
    if (soundMute)
    {
        for (int i=0;i<SOUND_CHANNELS;i++)
            StopSound(i);
    }
}

//---------------------------------------------------------------------------
#pragma package(smart_init)
