/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef __RENDER_H__
#define __RENDER_H__

#ifndef PLATFORM_UNIX
#include <windows.h>
#else
#include "linux_inc.h"
#endif
#include "poly.h"

#define MAX_WALLS 8192
#define MAX_SPRITES 4096

#define WALLINDEX_CEILING -1
#define WALLINDEX_FLOOR -2

#define TM_VIEW 0
#define TM_MODEL 1

struct TexCacheElem
{
    char* fn;
    char* afn;
    void* tex;
    TexCacheElem *next;
};

struct RenderStats
{
    int polyDrawn;
    int polyTotal;
    int polyReflect;
};

#define MAX_MODES 64
struct ModeList
{
    struct
    {
        int w;
        int h;
    } mode[MAX_MODES];
    int count;
};

struct SpriteToDraw
{
    int type;
    int spriteIndex;
    float distSq;
};

struct MATRIX
{
    float _11,_12,_13,_14;
    float _21,_22,_23,_24;
    float _31,_32,_33,_34;
    float _41,_42,_43,_44;
};

class Map;
class Art;

class Render
{
protected:
    SpriteToDraw spritesToDraw[MAX_SPRITES];
    int numSpritesToDraw;
    MATRIX viewMatrix;
    int scrnX,scrnY;

    void MarkSpritesInSector(Map *map,int sectNum);
    void RenderSector(Map *map,int sectNum);
    int RenderVisibleSectors(Map *map,int sectNum,float sx,float sy,float ex,float ey);
public:
    Render();
    virtual ~Render();
    virtual int Initialized();
    virtual void EnumModes(ModeList *modes16,ModeList *modes32)=0;
    virtual void ChangeResolution(int scrnX,int scrnY,int depth)=0;
    virtual void SetRenderWnd(HWND hWnd)=0;
    virtual void BeginRender()=0;
    virtual void RenderPoly(Poly &poly)=0;
    virtual void RenderPolyList(PolyList &list)=0;
    virtual int RenderMap(Map *map,int sectNum);
    virtual void EndRender()=0;
    virtual void TranslateVertex(Vertex &vert);
    virtual void BeginScene()=0;
    virtual void EndScene()=0;
    virtual void SetXPos(float x)=0;
    virtual void SetYPos(float y)=0;
    virtual void SetZPos(float z)=0;
    virtual void AddXPos(float x)=0;
    virtual void AddYPos(float y)=0;
    virtual void AddZPos(float z)=0;
    virtual void SetXRotate(float x)=0;
    virtual void SetYRotate(float y)=0;
    virtual void SetZRotate(float z)=0;
    virtual void AddXRotate(float x)=0;
    virtual void AddYRotate(float y)=0;
    virtual void AddZRotate(float z)=0;
    virtual void GoForward(float d)=0;
    virtual void GoSide(float d)=0;
    virtual float GetXPos()=0;
    virtual float GetYPos()=0;
    virtual float GetZPos()=0;
    virtual float GetXRotate()=0;
    virtual float GetYRotate()=0;
    virtual float GetZRotate()=0;
    virtual Texture* LoadTextureBMP(char *filename)=0;
    virtual Texture* LoadAlphaTextureBMP(char *filename,char *alphaname)=0;
    virtual void CreateMemoryTexture(Texture* tex)=0;
    virtual void UpdateMemoryTexture(Texture* tex)=0;
    virtual void ReloadTexture(Texture* tex)=0;
    virtual void FreeTexture(Texture* tex)=0;
    virtual void UseOriginView()=0;
    virtual void UseNormalView()=0;
    virtual void StartText()=0;
    virtual void EndText()=0;
    virtual void RenderText(int x,int y,char *text,unsigned long color)=0;
    virtual void* AddFont(HFONT font)=0;
    virtual void UseFont(void* font)=0;
    virtual void GetStats(RenderStats *stat)=0;
    virtual void BeginBitmaps()=0;
    virtual void RenderBitmap(int x,int y,Art *art,int texIndex,unsigned long color)=0;
    virtual void RenderBitmap(int x,int y,Art *art,int texIndex,int palNum,unsigned long color)=0;
    virtual void RenderBitmap(int x,int y,Texture *tex,int w,int h,unsigned long color)=0;
    virtual void RenderBitmapYFlipped(int x,int y,Art *art,int texIndex,unsigned long color)=0;
    virtual void RenderScaledBitmap(int x,int y,int w,int h,Art *art,int texIndex,unsigned long color)=0;
    virtual void RenderScaledBitmap(int x,int y,int w,int h,Art *art,int texIndex,int palNum,unsigned long color)=0;
    virtual void EndBitmaps()=0;
    virtual void LoadPalette(int i,unsigned short *pal);
    virtual int GetScrnX() { return scrnX; }
    virtual int GetScrnY() { return scrnY; }
    virtual void UpdateViewMatrix();
    virtual void ScreenShot();
};

extern Render *render;

#endif
