/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


//---------------------------------------------------------------------------
#ifndef ConEngineH
#define ConEngineH
//---------------------------------------------------------------------------

#include <stdio.h>
#include <stdarg.h>
#include <string>
#include <map>
#include <vector>

const int MAXEPS = 4,
          MAXLVLS = 11;

using namespace std;

class ConEngine
{
  public:
    ConEngine();
    ~ConEngine();
    void ParseFile(char *fname);
    void AddDefine(char *name, int val);
    int GetDefine(char *name);
    void AddQuote(int num, char *val);
    const char *GetQuote(int num);
    const char *GetLevelName(int episode, int map);

  private:
    void _Parse(char *fname);
    char *_GetTok(FILE *fp, char *buf, bool word);
    bool _GetTokF(FILE *fp, char *buf, bool word);
    char *_PeekTok(FILE *fp, char *buf);
    int _ToVal(char *str);
    int _GetVal(FILE *fp);
    bool _IsNum(char *name);
    bool _IsVal(char *name);
    void _GenerateCode(FILE *fp, char *stok, char *end, bool block);
    int _VFuncParams(int tok);
    int _MakeVFunc(char *tok);
    char *_GetVFunc(int vfunc, char *buf);
    void _Dump();

    struct _Level
    {
      char fname[14],
           par[6],
           par3dr[6],
           title[33];
    };

    struct _Sound
    {
      char fname[14];
      int pitch1,
          pitch2,
          priority,
          type,
          volume;
    };

    struct _Velocity
    {
      int horz,
          vert;
    };

    struct _Actor
    {
      int strength,
          action,
          speed,
          ai,
          code;
    };

    struct _Action
    {
      int startframe,
          frames,
          viewtype,
          incvalue,
          delay;
    };

    enum VFUNCS { ACTION, ADDAMMO, ADDINVENTORY, ADDKILLS, ADDPHEALTH,
                  ADDSTRENGTH, ADDWEAPON, AI, CACTOR, CLIPDIST, COUNT, CSTAT,
                  CSTATOR, DEBRIS, DEBUG, ENDOFGAME, FALL, GETLASTPAL,
                  GLOBALSOUND, GUTS, HITRADIUS, IFACTION, IFACTIONCOUNT,
                  IFACTOR, IFACTORNOTSTAYPUT, IFAI, IFANGDIFFL, IFANGDIFFG,
                  IFAWAYFROMWALL, IFBULLETNEAR, IFCANSEE, IFCANSEETARGET,
                  IFCANSHOOTTARGET, IFCEILINGDISTL, IFCOUNT, IFDEAD,
                  IFFLOORDISTL, IFGAPZL, IFGOTWEAPONCE, IFHITSPACE,
                  IFHITWEAPON, IFINOUTERSPACE, IFINSPACE, IFINWATER, IFMOVE,
                  IFMULTIPLAYER, IFNOSOUNDS, IFNOTMOVING, IFONWATER,
                  IFOUTSIDE, IFP, IFPDISTG, IFPDISTL, IFPHEALTHL, IFPHEALTHG,
                  IFPINVENTORY, IFRESPAWN, IFRND, IFSPAWNEDBY, IFSPRITEPAL,
                  IFSQUISHED, IFSTRENGTH, IFWASWEAPON, KILLIT, LOTSOFGLASS,
                  MAIL, MIKESND, MONEY, MOVE, OPERATE, PALFROM, PAPER, PKICK,
                  PSTOMP, QUOTE, RESETACTIONCOUNT, RESETCOUNT, RESETPLAYER,
                  RESPAWNHITAG, SHOOT, SIZEAT, SIZETO, SLEEPTIME,
                  SOUND, SOUNDONCE, SPAWN, SPRITEPAL, STATE, STOPSOUND,
                  STRENGTH, TIP, TOSSWEAPON, WACKPLAYER,
                  CALL, JUMP, RETURN};

    map<string, int> _defines;
    map<int, string> _quotes;
    _Level _levels[MAXEPS][MAXLVLS];
    char _musictitle[14],
         _musicend[14],
         _music[MAXEPS][MAXLVLS][14];
    map<string, int> _sounds;
    vector<_Sound> _sound; 
    map<string, int> _states;
    vector<int> _code;
    map<string, int> _velocities;
    vector<_Velocity> _velocity;
    map<string, int> _actors;
    vector<_Actor> _actor;
    map<string, int> _actions;
    vector<_Action> _action;    
};

static void Error(char *str, ...);
static void strccat(char *str, int c);
static void strtolower(char *str);

#endif

