/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_SSHSESSIONSETTINGDATAACCESS_H_
#define OPENDRIM_SSHSESSIONSETTINGDATAACCESS_H_

#include "SSH_Common.h"

#include "OpenDRIM_SSHSessionSettingData.h"
#include "assocOpenDRIM_SSHSessionSettingData.h"

int SSH_OpenDRIM_SSHSessionSettingData_load(const CMPIBroker* broker, string& errorMessage);

int SSH_OpenDRIM_SSHSessionSettingData_unload(string& errorMessage);

int SSH_OpenDRIM_SSHSessionSettingData_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHSessionSettingData>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHSessionSettingData_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHSessionSettingData& instance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHSessionSettingData_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHSessionSettingData& newInstance, const OpenDRIM_SSHSessionSettingData& oldInstance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHSessionSettingData_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHSessionSettingData& instance, string& errorMessage);

int SSH_OpenDRIM_SSHSessionSettingData_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHSessionSettingData& instance, string& errorMessage);

int SSH_OpenDRIM_SSHSessionSettingData_associatorSettingDataToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SettingData_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHSessionSettingData_associatorManagedElementToSettingData(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& SettingData_associatedInstances, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHSessionSettingData_referenceSettingDataToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SettingData_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_SSHSessionSettingData>& OpenDRIM_SSHSessionSettingData_instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHSessionSettingData_referenceManagedElementToSettingData(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& SettingData_instances, vector<OpenDRIM_SSHSessionSettingData>& OpenDRIM_SSHSessionSettingData_instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHSessionSettingData_populate(OpenDRIM_SSHSessionSettingData& instance, string& errorMessage);

#endif /*OPENDRIM_SSHSESSIONSETTINGDATAACCESS_H_*/
