/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_POWERSUPPLYCAPABILITIESACCESS_H_
#define OPENDRIM_POWERSUPPLYCAPABILITIESACCESS_H_

#include "PowerSupply_Common.h"

#include "OpenDRIM_PowerSupplyCapabilities.h"
#include "assocOpenDRIM_PowerSupplyCapabilities.h"

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_unload(string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PowerSupplyCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PowerSupplyCapabilities& instance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupplyCapabilities& newInstance, const OpenDRIM_PowerSupplyCapabilities& oldInstance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupplyCapabilities& instance, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupplyCapabilities& instance, string& errorMessage);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_PowerSupplyCapabilities>& OpenDRIM_PowerSupplyCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_PowerSupplyCapabilities>& OpenDRIM_PowerSupplyCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_PowerSupplyCapabilities_populate(OpenDRIM_PowerSupplyCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_POWERSUPPLYCAPABILITIESACCESS_H_*/
