// File:	StepToGeom_MakeHyperbola.cxx
// Created:	Thu Sep  8 08:25:12 1994
// Author:	Frederic MAUPAS
//		<fma@nonox>


#include <StepToGeom_MakeHyperbola.ixx>
#include <StepGeom_Hyperbola.hxx>
#include <StepGeom_Axis2Placement3d.hxx>
#include <Geom_Axis2Placement.hxx>
#include <StepToGeom_MakeAxis2Placement.hxx>
#include <gp_Ax2.hxx>
#include <StdFail_NotDone.hxx>
#include <UnitsMethods.hxx>

//=============================================================================
// Creation d' un Hyperbola de Geom a partir d' un Hyperbola de Step
//=============================================================================

StepToGeom_MakeHyperbola::StepToGeom_MakeHyperbola
  ( const Handle(StepGeom_Hyperbola)& C)
{
  StepGeom_Axis2Placement   AxisSelect;
  Handle(StepGeom_Axis2Placement3d) A;
  Handle(Geom_Axis2Placement)    A1;
  gp_Ax2                         A2;
  Standard_Real                  majorR, minorR;

  AxisSelect  = C->Position();
  if (AxisSelect.CaseNum(AxisSelect.Value()) == 2) {
    StepToGeom_MakeAxis2Placement
      MkAxis2(Handle(StepGeom_Axis2Placement3d)::DownCast(AxisSelect.Value()));
    A1 = MkAxis2.Value();
    A2 = A1->Ax2();
    majorR = C->SemiAxis() * UnitsMethods::LengthFactor();
    minorR = C->SemiImagAxis() * UnitsMethods::LengthFactor();
    theHyperbola = new Geom_Hyperbola(A2, majorR, minorR);
    done = Standard_True;
  }
  else {
    done= Standard_False;
  }
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_Hyperbola) &
      StepToGeom_MakeHyperbola::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theHyperbola;
}
