
#include <Handle_Standard_Transient.hxx>
#include <Standard_Transient.hxx>

#include <Standard_Failure.hxx>
#include <Standard_NullObject.hxx>
#include <Standard_RangeError.hxx>
#include <Standard_ImmutableObject.hxx>
#include <Standard_TypeMismatch.hxx>
#include <Standard_Type.hxx>

//
// The Initialization of the Standard_Transient variables
//
Handle_Standard_Type& Standard_Transient_Type_() 
{
  static const Handle_Standard_Type _Ancestors[]={NULL};
  static Handle_Standard_Type _aType 
    = new Standard_Type("Standard_Transient",
			sizeof(Standard_Transient),
			0,
     (Standard_Address) _Ancestors,
			NULL);

  return _aType;
}

//
// The Standard_Transient Methods
//

// The Method This 
//
Handle_Standard_Transient Standard_Transient::This() const
{
  Handle_Standard_Transient aHand(this);

  return aHand;
}

// Empty Destructor
//
Standard_Transient::~Standard_Transient()
{
}

//
//
const Handle(Standard_Type)& Standard_Transient::DynamicType () const
{  
  return  STANDARD_TYPE(Standard_Transient);
}

//
//
Standard_Boolean Standard_Transient::IsInstance(const Handle(Standard_Type) &AType) const
{
  return (Standard_Boolean) (AType ==  DynamicType());
}

//
//
Standard_Boolean Standard_Transient::IsInstance(const Standard_CString theTypeName) const
{
  return IsSimilar ( DynamicType()->Name(), theTypeName );
}

//
//
Standard_Boolean Standard_Transient::IsKind (const Handle(Standard_Type)& aType) const
{
  return DynamicType()->SubType ( aType );
//  return  (aType == STANDARD_TYPE(Standard_Transient));
}

//
//
Standard_Boolean Standard_Transient::IsKind (const Standard_CString theTypeName) const
{
  return DynamicType()->SubType ( theTypeName );
}

//============================================================================
Standard_Integer Standard_Transient::HashCode(const Standard_Integer Lim)const
{
  Handle(Standard_Transient) me = this;
  return ::HashCode(me, Lim);
}


void Standard_Transient::ShallowDump(Standard_OStream& theStream) const
{
  theStream << "class " << DynamicType()->Name() << " at " << this << endl;
}


void Standard_Transient::Delete() const
 { 
   delete((Standard_Transient *)this); 
 }
