// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_Switch_HeaderFile
#define _Vrml_Switch_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! defines a Switch node of VRML specifying group properties. <br>
//!  This  group  node  traverses  one,  none,  or  all  of  its  children. <br>
//!  One  can  use  this  node  to  switch  on  and  off  the  effects  of  some <br>
//!  properties  or  to  switch  between  different  properties. <br>
//!  The  whichChild  field  specifies  the  index  of  the  child  to  traverse, <br>
//!  where  the  first  child  has  index  0. <br>
//!  A  value  of  -1  (the  default)  means  do  not  traverse  any  children. <br>
//!  A  value  of  -3  traverses  all  children,  making  the  switch  behave  exactly <br>
//!  like  a  regular  Group. <br>
class Vrml_Switch  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_Switch(const Standard_Integer aWhichChild = -1);


Standard_EXPORT   void SetWhichChild(const Standard_Integer aWhichChild) ;


Standard_EXPORT   Standard_Integer WhichChild() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myWhichChild;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
