// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Viewer2dTest_HeaderFile
#define _Viewer2dTest_HeaderFile

#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TopTools_HArray1OfShape_HeaderFile
#include <Handle_TopTools_HArray1OfShape.hxx>
#endif
#ifndef _Handle_AIS2D_InteractiveObject_HeaderFile
#include <Handle_AIS2D_InteractiveObject.hxx>
#endif
#ifndef _AIS_KindOfInteractive_HeaderFile
#include <AIS_KindOfInteractive.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfTransient_HeaderFile
#include <Handle_TColStd_HArray1OfTransient.hxx>
#endif
#ifndef _Handle_V2d_Viewer_HeaderFile
#include <Handle_V2d_Viewer.hxx>
#endif
#ifndef _Handle_AIS2D_InteractiveContext_HeaderFile
#include <Handle_AIS2D_InteractiveContext.hxx>
#endif
#ifndef _Handle_V2d_View_HeaderFile
#include <Handle_V2d_View.hxx>
#endif
#ifndef _Handle_Viewer2dTest_EventManager_HeaderFile
#include <Handle_Viewer2dTest_EventManager.hxx>
#endif
class TopoDS_Shape;
class TopTools_HArray1OfShape;
class AIS2D_InteractiveObject;
class TColStd_HArray1OfTransient;
class V2d_Viewer;
class AIS2D_InteractiveContext;
class V2d_View;
class Viewer2dTest_EventManager;
class Draw_Interpretor;
class Viewer2dTest_EventManager;
class Viewer2dTest_DoubleMapOfInteractiveAndName;
class Viewer2dTest_DataMapOfText;
class Viewer2dTest_DoubleMapNodeOfDoubleMapOfInteractiveAndName;
class Viewer2dTest_DoubleMapIteratorOfDoubleMapOfInteractiveAndName;
class Viewer2dTest_DataMapNodeOfDataMapOfText;
class Viewer2dTest_DataMapIteratorOfDataMapOfText;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class Viewer2dTest  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!          implemented in Viewer2dTest_ViewerCommands.cxx <br>
Standard_EXPORT static  void ViewerInit() ;

//!  waits until a shape of type <aType> is picked in the AIS2D Viewer and returns it. <br>
//! if <aType> == TopAbs_Shape, any shape can be picked... <br>
//! MaxPick  is the Max number before exiting, if no pick is successfull <br>
Standard_EXPORT static  TopoDS_Shape PickShape(const TopAbs_ShapeEnum aType,const Standard_Integer MaxPick = 5) ;

//! wait until the array is filled with picked shapes. <br>
//!          returns True if the array is filled. <br>
//!          exit if number of unsuccesfull picks =  <MaxPick> <br>
Standard_EXPORT static  Standard_Boolean PickShapes(const TopAbs_ShapeEnum aType,Handle(TopTools_HArray1OfShape)& thepicked,const Standard_Integer MaxPick = 5) ;

//! waits until an interactive object of a given Type <br>
//!          and signature is picked (defaut values authorize <br>
//!          selection of any Interactive Object) <br>
//!          exit if number of unsuccesfull picks =  <MaxPick> <br>
Standard_EXPORT static  Handle_AIS2D_InteractiveObject PickObject(const AIS_KindOfInteractive Type = AIS_KOI_None,const Standard_Integer Signature = -1,const Standard_Integer MaxPick = 5) ;

//! selection of several interactive objects. Number is given <br>
//!          by the size of <thepicked> <br>
//!          exit if number of unsuccesfull picks =  <MaxPick> <br>
Standard_EXPORT static  Standard_Boolean PickObjects(Handle(TColStd_HArray1OfTransient)& thepicked,const AIS_KindOfInteractive Type = AIS_KOI_None,const Standard_Integer Signature = -1,const Standard_Integer MaxPick = 5) ;


Standard_EXPORT static  void GetMousePosition(Standard_Integer& xpix,Standard_Integer& ypix) ;


Standard_EXPORT static  Handle_V2d_Viewer GetViewerFromContext() ;


Standard_EXPORT static  Handle_V2d_Viewer GetCollectorFromContext() ;


Standard_EXPORT static  Handle_AIS2D_InteractiveContext GetAIS2DContext() ;


Standard_EXPORT static  void SetAIS2DContext(const Handle(AIS2D_InteractiveContext)& aContext) ;


Standard_EXPORT static  Handle_V2d_View CurrentView() ;


Standard_EXPORT static  void CurrentView(const Handle(V2d_View)& aViou) ;


Standard_EXPORT static  void Clear() ;

//!      puts  <aMgr>   as     current  eventmanager  (the <br>
//!          move,select,...will be applied to <aMgr> <br>
Standard_EXPORT static  void SetEventManager(const Handle(Viewer2dTest_EventManager)& aMgr) ;

//! removes the last EventManager from the list. <br>
Standard_EXPORT static  void UnsetEventManager() ;

//! clear the list of EventManagers and <br>
//!          sets the default EventManager as current <br>
Standard_EXPORT static  void ResetEventManager() ;


Standard_EXPORT static  Handle_Viewer2dTest_EventManager CurrentEventManager() ;


Standard_EXPORT static  void RemoveSelected() ;


Standard_EXPORT static  void StandardModeActivation(const Standard_Integer Mode) ;


Standard_EXPORT static  void Commands(Draw_Interpretor& theCommands) ;


Standard_EXPORT static  void MyCommands(Draw_Interpretor& theCommands) ;


Standard_EXPORT static  void GeneralCommands(Draw_Interpretor& theCommands) ;


Standard_EXPORT static  void ViewerCommands(Draw_Interpretor& theCommands) ;


Standard_EXPORT static  void DisplayCommands(Draw_Interpretor& theCommands) ;


Standard_EXPORT static  void ObjectCommands(Draw_Interpretor& theCommands) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class Viewer2dTest_EventManager;
friend class Viewer2dTest_DoubleMapOfInteractiveAndName;
friend class Viewer2dTest_DataMapOfText;
friend class Viewer2dTest_DoubleMapNodeOfDoubleMapOfInteractiveAndName;
friend class Viewer2dTest_DoubleMapIteratorOfDoubleMapOfInteractiveAndName;
friend class Viewer2dTest_DataMapNodeOfDataMapOfText;
friend class Viewer2dTest_DataMapIteratorOfDataMapOfText;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
