// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeFix_EdgeConnect_HeaderFile
#define _ShapeFix_EdgeConnect_HeaderFile

#ifndef _TopTools_DataMapOfShapeShape_HeaderFile
#include <TopTools_DataMapOfShapeShape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
class TopoDS_Edge;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Makes vertices to be shared to connect edges, <br>
//!           updates positions and tolerances for shared vertices. <br>
//!           Accepts edges bounded by two vertices each. <br>
class ShapeFix_EdgeConnect  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT ShapeFix_EdgeConnect();

//! Adds information on connectivity between start vertex <br>
//!           of second edge and end vertex of first edge, <br>
//!           taking edges orientation into account <br>
Standard_EXPORT   void Add(const TopoDS_Edge& aFirst,const TopoDS_Edge& aSecond) ;

//! Adds connectivity information for the whole shape. <br>
//!           Note: edges in wires must be well ordered <br>
//!           Note: flag Closed should be set for closed wires <br>
Standard_EXPORT   void Add(const TopoDS_Shape& aShape) ;

//! Builds shared vertices, updates their positions and tolerances <br>
Standard_EXPORT   void Build() ;

//! Clears internal data structure <br>
Standard_EXPORT   void Clear() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopTools_DataMapOfShapeShape myVertices;
TopTools_DataMapOfShapeListOfShape myLists;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
