// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _PrsMgr_PresentableObject_HeaderFile
#define _PrsMgr_PresentableObject_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentableObject_HeaderFile
#include <Handle_PrsMgr_PresentableObject.hxx>
#endif

#ifndef _PrsMgr_Presentations_HeaderFile
#include <PrsMgr_Presentations.hxx>
#endif
#ifndef _PrsMgr_TypeOfPresentation3d_HeaderFile
#include <PrsMgr_TypeOfPresentation3d.hxx>
#endif
#ifndef _TopLoc_Location_HeaderFile
#include <TopLoc_Location.hxx>
#endif
#ifndef _Graphic3d_CTransPersStruct_HeaderFile
#include <Graphic3d_CTransPersStruct.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_Graphic3d_Structure_HeaderFile
#include <Handle_Graphic3d_Structure.hxx>
#endif
#ifndef _Handle_Graphic3d_DataStructureManager_HeaderFile
#include <Handle_Graphic3d_DataStructureManager.hxx>
#endif
#ifndef _PrsMgr_Presentation3d_HeaderFile
#include <PrsMgr_Presentation3d.hxx>
#endif
#ifndef _Handle_Geom_Transformation_HeaderFile
#include <Handle_Geom_Transformation.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager2d_HeaderFile
#include <Handle_PrsMgr_PresentationManager2d.hxx>
#endif
#ifndef _Handle_Graphic2d_GraphicObject_HeaderFile
#include <Handle_Graphic2d_GraphicObject.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager3d_HeaderFile
#include <Handle_PrsMgr_PresentationManager3d.hxx>
#endif
#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Handle_Prs3d_Projector_HeaderFile
#include <Handle_Prs3d_Projector.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager_HeaderFile
#include <Handle_PrsMgr_PresentationManager.hxx>
#endif
#ifndef _Handle_PrsMgr_Presentation_HeaderFile
#include <Handle_PrsMgr_Presentation.hxx>
#endif
#ifndef _Graphic3d_TransModeFlags_HeaderFile
#include <Graphic3d_TransModeFlags.hxx>
#endif
class Standard_NotImplemented;
class PrsMgr_PresentationManager;
class Graphic3d_Structure;
class Graphic3d_DataStructureManager;
class Geom_Transformation;
class PrsMgr_PresentationManager2d;
class Graphic2d_GraphicObject;
class PrsMgr_PresentationManager3d;
class Prs3d_Presentation;
class Prs3d_Projector;
class PrsMgr_Presentation;
class PrsMgr_Presentations;
class gp_Pnt;
class TColStd_ListOfInteger;
class TopLoc_Location;


//! A framework to supply the Graphic2d or Graphic3d <br>
//! structure of the object to be presented. On the first <br>
//! display request, this structure is created by calling the <br>
//! appropriate algorithm and retaining this frameworkfor <br>
//! further display. <br>
//! This abstract framework is inherited in Application <br>
//! Interactive Services (AIS), notably in: <br>
//! -   AIS_InteractiveObject <br>
//! -   AIS_ConnectedInteractive <br>
//! -   AIS_MultipleConnectedInteractive <br>
//! -   AIS_Shape <br>
//!   Consequently, 3D presentation should be handled by <br>
//! the relevant daughter classes and their member <br>
//! functions in AIS. This is particularly true in the <br>
//! creation of new interactive objects. <br>
class PrsMgr_PresentableObject : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns information on whether the object accepts display in HLR mode or not. <br>
Standard_EXPORT   PrsMgr_TypeOfPresentation3d TypeOfPresentation3d() const;

//!  Sets  up  Transform  Persistence Mode  for  this  object <br>
Standard_EXPORT virtual  void SetTransformPersistence(const Graphic3d_TransModeFlags& aFlag,const gp_Pnt& APoint) ;

//!  Calls previous method  with  point  (0,0,0) <br>
Standard_EXPORT   void SetTransformPersistence(const Graphic3d_TransModeFlags& aFlag) ;

//!  Gets  Transform  Persistence Mode  for  this  object <br>
Standard_EXPORT   Graphic3d_TransModeFlags GetTransformPersistenceMode() const;

//!  Gets  point  of  transform  persistence for  this  object <br>
Standard_EXPORT   gp_Pnt GetTransformPersistencePoint() const;


Standard_EXPORT   void SetTypeOfPresentation(const PrsMgr_TypeOfPresentation3d aType) ;

//! flags the Prs of mode <AMode> to be Updated. <br>
//!          the Update will be done when needed. <br>
Standard_EXPORT   void SetToUpdate(const Standard_Integer aMode) ;

//! flags all the Presentations to be Updated. <br>
Standard_EXPORT   void SetToUpdate() ;

//! gives the list of modes which are flagged "to be updated". <br>
Standard_EXPORT   void ToBeUpdated(TColStd_ListOfInteger& ListOfMode) const;


Standard_EXPORT virtual  void SetLocation(const TopLoc_Location& aLoc) ;


Standard_EXPORT   Standard_Boolean HasLocation() const;

 const TopLoc_Location& Location() const;


Standard_EXPORT virtual  void ResetLocation() ;


Standard_EXPORT virtual  void UpdateLocation() ;


Standard_EXPORT virtual  void UpdateLocation(const Handle(Prs3d_Presentation)& P) ;
//Standard_EXPORT ~PrsMgr_PresentableObject();


friend class PrsMgr_PresentationManager;
friend 

Standard_EXPORT   Handle_Graphic3d_Structure PrsMgr_Presentation3d::Compute(const Handle(Graphic3d_DataStructureManager)& aProjector) ;
friend 

Standard_EXPORT   void PrsMgr_Presentation3d::Compute(const Handle(Graphic3d_DataStructureManager)& aProjector,const Handle(Graphic3d_Structure)& aGivenStruct) ;
friend 

Standard_EXPORT   Handle_Graphic3d_Structure PrsMgr_Presentation3d::Compute(const Handle(Graphic3d_DataStructureManager)& aProjector,const Handle(Geom_Transformation)& TheTrsf) ;
friend 

Standard_EXPORT   void PrsMgr_Presentation3d::Compute(const Handle(Graphic3d_DataStructureManager)& aProjector,const Handle(Geom_Transformation)& TheTrsf,const Handle(Graphic3d_Structure)& aGivenStruct) ;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


Standard_EXPORT PrsMgr_PresentableObject(const PrsMgr_TypeOfPresentation3d aTypeOfPresentation3d = PrsMgr_TOP_AllView);

//! Calculates the 2D view aPresentation and its <br>
//! updates. The latter are managed by aPresentationManager. <br>
//! aPresentableObject has the display mode aMode; <br>
//! this has the default value of 0, that is, the wireframe display mode. <br>
//! Note that this syntax is not used in AIS as that <br>
//! package only concerns 3D display. <br>
Standard_EXPORT virtual  void Compute(const Handle(PrsMgr_PresentationManager2d)& aPresentationManager,const Handle(Graphic2d_GraphicObject)& aPresentation,const Standard_Integer aMode = 0) ;

//! Calculates the 3D view aPresentation and its <br>
//! updates. The latter are managed by aPresentationManager. <br>
//! aPresentableObject has the display mode aMode; <br>
//! this has the default value of 0, that is, the wireframe display mode. <br>
Standard_EXPORT virtual  void Compute(const Handle(PrsMgr_PresentationManager3d)& aPresentationManager,const Handle(Prs3d_Presentation)& aPresentation,const Standard_Integer aMode = 0) ;

//! Calculates the 3D view aPresentation and its <br>
//! updates. The latter are managed by <br>
//! aPresentationManager. Each of the views in the <br>
//! viewer and every modification such as rotation, for <br>
//! example, entails recalculation. <br>
//! It must be redefined to implement hidden line removal <br>
//! for the object. The user never calls this method <br>
//! himself. This is done via the InteractiveContext object <br>
//! and is dependent on the point of view from which the <br>
//! object is displayed. <br>
Standard_EXPORT virtual  void Compute(const Handle(Prs3d_Projector)& aProjector,const Handle(Prs3d_Presentation)& aPresentation) ;

//! Calculates the 3D view aPresentation and its <br>
//! updates. The latter are managed by <br>
//! aPresentationManager. A point of view is provided <br>
//! by the projector aProjector, and the geometric <br>
//! transformation which has transformed associated <br>
//! presentable objects is specified by aTrsf. <br>
//! This function is to be used in case where a hidden <br>
//! line removal display cannot be calculated <br>
//! automatically. This occurs   when associated <br>
//! presentable objects have been transformed <br>
//! geometrically, but not translated. <br>
//! Warning <br>
//! The transformation aTrsf must be applied to the <br>
//! object before computation. <br>
Standard_EXPORT virtual  void Compute(const Handle(Prs3d_Projector)& aProjector,const Handle(Geom_Transformation)& aTrsf,const Handle(Prs3d_Presentation)& aPresentation) ;

//! recomputes all presentations of the object. <br>
Standard_EXPORT   void Update(const Standard_Boolean AllModes = Standard_False) ;

//! Recomputes the presentation in the given mode. <br>
//!          If ClearOther is true, other presentation will be cleared. <br>
Standard_EXPORT   void Update(const Standard_Integer aMode,const Standard_Boolean ClearOther) ;

//! High-level interface for controlling polygon offsets <br>
Standard_EXPORT virtual  void Fill(const Handle(PrsMgr_PresentationManager)& aPresentationManager,const Handle(PrsMgr_Presentation)& aPresentation,const Standard_Integer aMode = 0) ;


Standard_EXPORT   PrsMgr_Presentations& Presentations() ;


 // Fields PROTECTED
 //
PrsMgr_Presentations myPresentations;
PrsMgr_TypeOfPresentation3d myTypeOfPresentation3d;
TopLoc_Location myLocation;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Graphic3d_CTransPersStruct myTransformPersistence;


};


#include <PrsMgr_PresentableObject.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
