// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MAT_Zone_HeaderFile
#define _MAT_Zone_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MAT_Zone_HeaderFile
#include <Handle_MAT_Zone.hxx>
#endif

#ifndef _MAT_SequenceOfArc_HeaderFile
#include <MAT_SequenceOfArc.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_MAT_BasicElt_HeaderFile
#include <Handle_MAT_BasicElt.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_MAT_Arc_HeaderFile
#include <Handle_MAT_Arc.hxx>
#endif
#ifndef _Handle_MAT_Node_HeaderFile
#include <Handle_MAT_Node.hxx>
#endif
#ifndef _MAT_Side_HeaderFile
#include <MAT_Side.hxx>
#endif
class MAT_BasicElt;
class MAT_Arc;
class MAT_Node;



//!          Definition of Zone of Proximity of a BasicElt : <br>
//!          ---------------------------------------------- <br>
//!          A Zone of proximity is the set of the points which are <br>
//!          more near from the BasicElt than any other. <br>
//! <br>
class MAT_Zone : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT MAT_Zone();

//! Compute the frontier of the Zone of proximity. <br>
Standard_EXPORT MAT_Zone(const Handle(MAT_BasicElt)& aBasicElt);

//! Compute the frontier of the Zone of proximity. <br>
Standard_EXPORT   void Perform(const Handle(MAT_BasicElt)& aBasicElt) ;

//! Return the number Of Arcs On the frontier of <me>. <br>
Standard_EXPORT   Standard_Integer NumberOfArcs() const;

//! Return the  Arc number <Index>  on the frontier. <br>
//!  of  <me>. <br>
Standard_EXPORT   Handle_MAT_Arc ArcOnFrontier(const Standard_Integer Index) const;

//! Return TRUE if <me> is not empty . <br>
Standard_EXPORT   Standard_Boolean NoEmptyZone() const;

//! Return TRUE if <me> is Limited. <br>
Standard_EXPORT   Standard_Boolean Limited() const;
//Standard_EXPORT ~MAT_Zone();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Handle_MAT_Node NodeForTurn(const Handle(MAT_Arc)& anArc,const Handle(MAT_BasicElt)& aBasicElt,const MAT_Side aSide) const;


 // Fields PRIVATE
 //
MAT_SequenceOfArc frontier;
Standard_Boolean limited;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
