// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GccEnt_QualifiedLin_HeaderFile
#define _GccEnt_QualifiedLin_HeaderFile

#ifndef _GccEnt_Position_HeaderFile
#include <GccEnt_Position.hxx>
#endif
#ifndef _gp_Lin2d_HeaderFile
#include <gp_Lin2d.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class gp_Lin2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& GccEnt_QualifiedLin_Type_();

//! Describes a qualified 2D line. <br>
//! A qualified 2D line is a line (gp_Lin2d line) with a <br>
//! qualifier which specifies whether the solution of a <br>
//! construction algorithm using the qualified line (as an argument): <br>
//! -   is 'enclosed' by the line, or <br>
//! -   is built so that both the line and it are external to one another, or <br>
//! -   is undefined (all solutions apply). <br>
//! Note: the interior of a line is defined as the left-hand <br>
//! side of the line in relation to its orientation (i.e. when <br>
//! moving from the start to the end of the curve). <br>
class GccEnt_QualifiedLin  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 


//! Constructs a qualified line by assigning the qualifier <br>
//! Qualifier to the line Qualified. <br>
//! Qualifier may be: <br>
//! -   GccEnt_enclosed if the solution is enclosed by the line, or <br>
//! -   GccEnt_outside if both the solution and the line are external to one another, or <br>
//! -   GccEnt_unqualified if all solutions apply. <br>
//! Note : the interior of a line is defined as the left-hand <br>
//! side of the line in relation to its orientation. <br>
Standard_EXPORT GccEnt_QualifiedLin(const gp_Lin2d& Qualified,const GccEnt_Position Qualifier);

//! Returns a 2D line to which the qualifier is assigned. <br>
Standard_EXPORT   gp_Lin2d Qualified() const;


//! Returns the qualifier of this qualified line, if it is "enclosed" or <br>
//!   "outside", or <br>
//! -   GccEnt_noqualifier if it is unqualified. <br>
Standard_EXPORT   GccEnt_Position Qualifier() const;

//! Returns true if the solution is unqualified and false in <br>
//!          the other cases. <br>
Standard_EXPORT   Standard_Boolean IsUnqualified() const;

//! Returns true if the solution is Enclosed in the Lin2d and false in <br>
//!          the other cases. <br>
Standard_EXPORT   Standard_Boolean IsEnclosed() const;

//! Returns true if the solution is Outside the Lin2d and false in <br>
//!          the other cases. <br>
Standard_EXPORT   Standard_Boolean IsOutside() const;
GccEnt_QualifiedLin( )
{
  
}

    GccEnt_Position _CSFDB_GetGccEnt_QualifiedLinTheQualifier() const { return TheQualifier; }
    void _CSFDB_SetGccEnt_QualifiedLinTheQualifier(const GccEnt_Position p) { TheQualifier = p; }
    const gp_Lin2d& _CSFDB_GetGccEnt_QualifiedLinTheQualified() const { return TheQualified; }




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& GccEnt_QualifiedLin_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
GccEnt_Position TheQualifier;
gp_Lin2d TheQualified;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
