#!/bin/csh -f

setenv CASROOT "Open CASCADE location/ros"
set OS_NAME=`uname`
if ( $?PATH ) then
      setenv PATH $CASROOT/../3rdparty/$OS_NAME/tcltk/bin:$CASROOT/$OS_NAME/bin:$PATH
else
      setenv PATH $CASROOT/../3rdparty/$OS_NAME/tcltk/bin:$CASROOT/$OS_NAME/bin
endif
if ( $?LD_LIBRARY_PATH ) then
      setenv LD_LIBRARY_PATH $CASROOT/../3rdparty/$OS_NAME/tcltk/lib:$CASROOT/$OS_NAME/lib:$LD_LIBRARY_PATH
else
      setenv LD_LIBRARY_PATH $CASROOT/../3rdparty/$OS_NAME/tcltk/lib:$CASROOT/$OS_NAME/lib
endif
setenv CSF_MDTVFontDirectory $CASROOT/src/FontMFT
setenv CSF_LANGUAGE us
setenv MMGT_CLEAR 1
setenv CSF_EXCEPTION_PROMPT 1
setenv CSF_SHMessage $CASROOT/src/SHMessage
setenv CSF_MDTVTexturesDirectory $CASROOT/src/Textures
setenv CSF_XSMessage $CASROOT/src/XSMessage
setenv CSF_StandardDefaults $CASROOT/src/StdResource
setenv CSF_PluginDefaults $CASROOT/src/StdResource
setenv CSF_XCAFDefaults $CASROOT/src/StdResource
setenv CSF_StandardLiteDefaults $CASROOT/src/StdResource
setenv CSF_GraphicShr $CASROOT/$OS_NAME/lib/libTKOpenGl.so
setenv CSF_UnitsLexicon $CASROOT/src/UnitsAPI/Lexi_Expr.dat
setenv CSF_UnitsDefinition $CASROOT/src/UnitsAPI/Units.dat
setenv CSF_IGESDefaults $CASROOT/src/XSTEPResource
setenv CSF_STEPDefaults $CASROOT/src/XSTEPResource
setenv CSF_XmlOcafResource $CASROOT/src/XmlOcafResource

setenv TCLHOME $CASROOT/../3rdparty/$OS_NAME/tcltk
setenv TCLLIBPATH $TCLHOME/lib
if ( $OS_NAME == "SunOS" ) then
      setenv ITK_LIBRARY $TCLLIBPATH/itk3.2
      setenv ITCL_LIBRARY $TCLLIBPATH/itcl3.2
      setenv TIX_LIBRARY $TCLLIBPATH/tix8.1
      setenv TK_LIBRARY $TCLLIBPATH/tk8.4
      setenv TCL_LIBRARY $TCLLIBPATH/tcl8.4
else if ( $OS_NAME == "Linux" ) then
      setenv ITK_LIBRARY $TCLLIBPATH/itk3.2
      setenv ITCL_LIBRARY $TCLLIBPATH/itcl3.2
      if ( $?TIX_LIBRARY ) then
            unsetenv TIX_LIBRARY
      endif
      setenv TK_LIBRARY $TCLLIBPATH/tk8.4
      setenv TCL_LIBRARY $TCLLIBPATH/tcl8.4
endif
