/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2009 Olivier Rolland <billl@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_MOV_H__
#define __OGMRIP_MOV_H__

#include <ogmrip-container.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_MOV          (ogmrip_mov_get_type ())
#define OGMRIP_MOV(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_MOV, OGMRipMov))
#define OGMRIP_MOV_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_MOV, OGMRipMovClass))
#define OGMRIP_IS_MOV(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_MOV))
#define OGMRIP_IS_MOV_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_MOV))

typedef struct _OGMRipMov      OGMRipMov;
typedef struct _OGMRipMovClass OGMRipMovClass;

struct _OGMRipMov
{
  OGMRipContainer parent_instance;
};

struct _OGMRipMovClass
{
  OGMRipContainerClass parent_class;
};

GType         ogmrip_mov_get_type (void);
OGMJobSpawn * ogmrip_mov_new      (const gchar *output);

G_END_DECLS

#endif /* __OGMRIP_MOV_H__ */

