/* OGMDvd - A wrapper library around libdvdread
 * Copyright (C) 2004-2008 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMDVD_PRIV_H__
#define __OGMDVD_PRIV_H__

#include "ogmdvd-types.h"

#if defined(HAVE_INTTYPES_H)
#include <inttypes.h>
#elif defined(HAVE_STDINT_H)
#include <stdint.h>
#endif

#include <dvdread/ifo_types.h>
#include <dvdread/ifo_read.h>

G_BEGIN_DECLS

/**
 * OGMDvdDisc:
 *
 * An opaque structure representing a DVD disc
 */
struct _OGMDvdDisc
{
  guint ref;
  gchar *device;
  dvd_reader_t *reader;
  ifo_handle_t *vmg_file;

  GSList *titles;
};

/**
 * OGMDvdTitle:
 *
 * An opaque structure representing a DVD title
 */
struct _OGMDvdTitle
{
  guint ref;
  guint nr;

  guint8 ttn;
  guint16 pgcn;

  OGMDvdDisc *disc;

  ifo_handle_t *vts_file;

  GSList *audio_streams;
  GSList *subp_streams;

  gint *bitrates;

  OGMDvdReader *reader;
  OGMDvdParser *parser;

  gint block_len;
  guchar *buffer;
  guchar *ptr;
};

/**
 * OGMDvdStream:
 *
 * An opaque structure representing a DVD stream
 */
struct _OGMDvdStream
{
  OGMDvdTitle *title;
  guint16 id;
  guint ref;
  guint nr;
};

/**
 * OGMDvdAudioStream:
 *
 * An opaque structure representing a DVD audio stream
 */
struct _OGMDvdAudioStream
{
  OGMDvdStream stream;
  audio_attr_t *attr;
};

/**
 * OGMDvdSubpStream:
 *
 * An opaque structure representing a DVD subtitle stream
 */
struct _OGMDvdSubpStream
{
  OGMDvdStream stream;
  subp_attr_t *attr;
};

/**
 * OGMDvdReader:
 *
 * An opaque structure to read the content of a DVD
 */
struct _OGMDvdReader
{
  gint ref;

  dvd_file_t *file;
  pgc_t *pgc;

  guint8 angle;

  guint8 first_cell;
  guint8 last_cell;

  /* private */

  guint8 cur_cell;

  guint32 cell_first_pack;
  guint32 cell_cur_pack;
  guint32 packs_left;

  guint32 pack_next_vobu;
};

/**
 * OGMDvdParser:
 *
 * An opaque structure to parse the content of a DVD
 */
struct _OGMDvdParser
{
  gint ref;
  gint max_frames;

  glong progressive_frames;
  glong video_frames;
  
  gint *bitrates;
  gint nbitrates;
  gint naudio_streams;
  
  gboolean *forced_subs;
  gint nforced_subs;
  gint nsubp_streams;
  
  /* SPU specific */
  int size_sub;
  int size_rle;
  int size_got;
  int pts_forced;
  int64_t pts;
  unsigned char *data;
  
  /* mpeg2 specific */
  // mpeg2dec_t *mpeg2;
  // const mpeg2_info_t *info;
  guint width, height;
};

gint64 _ogmdvd_get_ifo_size  (OGMDvdDisc *disc, guint vts);
gint64 _ogmdvd_get_bup_size  (OGMDvdDisc *disc, guint vts);
gint64 _ogmdvd_get_menu_size (OGMDvdDisc *disc, guint vts);
gint64 _ogmdvd_get_vob_size  (OGMDvdDisc *disc, guint vts);

G_END_DECLS

#endif /* __OGMDVD_PRIV_H__ */

