/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_AUDIO_COPY_H__
#define __OGMRIP_AUDIO_COPY_H__

#include <ogmrip-audio.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_AUDIO_COPY          (ogmrip_audio_copy_get_type ())
#define OGMRIP_AUDIO_COPY(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_AUDIO_COPY, OGMRipAudioCopy))
#define OGMRIP_AUDIO_COPY_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_AUDIO_COPY, OGMRipAudioCopyClass))
#define OGMRIP_IS_AUDIO_COPY(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_AUDIO_COPY))
#define OGMRIP_IS_AUDIO_COPY_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_AUDIO_COPY))

typedef struct _OGMRipAudioCopy      OGMRipAudioCopy;
typedef struct _OGMRipAudioCopyPriv  OGMRipAudioCopyPriv;
typedef struct _OGMRipAudioCopyClass OGMRipAudioCopyClass;

struct _OGMRipAudioCopy
{
  OGMRipAudio parent_instance;

  OGMRipAudioCopyPriv *priv;
};

struct _OGMRipAudioCopyClass
{
  OGMRipAudioClass parent_class;
};

GType         ogmrip_audio_copy_get_type (void);
OGMJobSpawn * ogmrip_audio_copy_new      (OGMDvdAudioStream *audio,
                                          const gchar       *output);

G_END_DECLS

#endif /* __OGMRIP_AUDIO_COPY_H__ */

