#! /usr/bin/perl
#* ============================================================
# * File  : rdfcast.pl
# * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
# * Date  : 2004-12-10
# * Description : iPodder XML RDF parser for streamtuned / mythstream
# *               test XML: http://del.icio.us/rss/audio/feedmeweirdthings
# *               (just parsing what's on my path, should study this, help?)
# * ============================================================ */

#<item rdf:about="http://slaveplanet.org/selbyville/Maiden_on_my_mind.mp3">
#  <title>Maiden On My Mind</title>
#  <link>http://slaveplanet.org/selbyville/Maiden_on_my_mind.mp3</link>
#  <description>Selbyville (theme to the motion picture 'Allston Cowboys', slaveplanet.org)</description>
#  <dc:creator>audio</dc:creator>
#  <dc:date>2004-12-10T04:19Z</dc:date>
#  <dc:subject>Selbyville Slaveplanet feedmeweirdthings</dc:subject>
#  <taxo:topics>
#    <rdf:Bag>
#      <rdf:li resource="http://del.icio.us/tag/Selbyville" />
#      <rdf:li resource="http://del.icio.us/tag/Slaveplanet" />
#      <rdf:li resource="http://del.icio.us/tag/feedmeweirdthings" />
#    </rdf:Bag>
#  </taxo:topics>
#<item>

use English;
use XML::Simple;
use XML::DOM;

$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line

eval { $data = $xml->XMLin($source); };

foreach my $entry (@{$data->{item}})
{
  $temp = $entry->{enclosure};
  
  if ($entry->{link} ne "")
  {
    $item = $doc->createElement('item');
    $item->appendChild( newNode('name', $entry->{title}) );
    $item->appendChild( newNode('url', $entry->{link}) );
    $item->appendChild( newNode('descr', $entry->{description}) );
    $item->appendChild( newNode('handler', 'STREAM_DL') );
    $root->appendChild($item);
  }
  
  # $meta = $doc->createElement('meta');
  # $meta->appendChild( newNode('name', 'page') );
  # $meta->appendChild( newNode('content', $entry->{description}) );
  # $meta->appendChild( newNode('viewer', 'html') );
  # $item->appendChild( $meta );
  
}

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


